<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';

/**
 * @brief operate user_field_value_set table 
 *
 */
class User_UserFieldValueSetBean extends Xoonips_BeanBase {

	/**
	 * Constructor
	 **/
	public function User_UserFieldValueSetBean($dirname, $trustDirname) {
		$this->Xoonips_BeanBase($dirname, $trustDirname);
		$this->setTableName('field_value_set', true);
	}
	
	/**
	 * get info by id
	 * 
	 * @param  var $id:id
	 * @return array
	 */
	public function getInfo($select_name,$title_id) {
		$sql = 'SELECT * FROM ' . $this->table . ' WHERE title_id=' . Xoonips_Utils::convertSQLStr($title_id);
		$sql .= ' AND select_name=' . Xoonips_Utils::convertSQLStr($select_name);
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$row = $this->fetchArray($result);
		
		$this->freeRecordSet($result);
		return $row;
	}
	
	/**
	 * get value by name
	 * 
	 * @param  var $name:selectname
	 * @return array
	 */
	public function getValue($name) {
		$sql = "SELECT * FROM $this->table WHERE select_name=" . Xoonips_Utils::convertSQLStr($name);
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$row = $this->fetchArray($result);
		
		$this->freeRecordSet($result);
		return $row;
	}
	
	/**
	 * check title
	 * 
	 * @param  var $name:selectname
	 *          var $title:name
	 * @return array
	 */
	public function checkTitle($name, $title) {
		$sql = "SELECT count(select_name) as cnt FROM $this->table WHERE select_name=" . Xoonips_Utils::convertSQLStr($name)
			. " and title=" . Xoonips_Utils::convertSQLStr($title);
   		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$ret = $this->fetchArray($result);

		$this->freeRecordSet($result);
		return $ret['cnt'];
	}

	/**
	 * check id
	 * 
	 * @param  var $name:selectname
	 *         var $title_id:id
	 * @return array
	 */
	public function checkTitleId($name, $title_id) {
		$sql = "SELECT count(select_name) as cnt FROM $this->table WHERE select_name=" . Xoonips_Utils::convertSQLStr($name)
			. " and title_id=" . Xoonips_Utils::convertSQLStr($title_id);
   		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$ret = $this->fetchArray($result);

		$this->freeRecordSet($result);
		return $ret['cnt'];
	}

	/**
	 * check id
	 * 
	 * @param  var $name:selectname
	 *         var $title_id:id
	 * @return array
	 */
	public function checkUsedTitleId($name, $title_id) {
		$userBean = Xoonips_BeanFactory::getBean('UsersBean', $this->dirname, $this->trustDirname);
		$userFieldManager = User_UserFieldManager::getInstance(true);
		$cnt = 0;
    	foreach ($userFieldManager->getFields() as $field) {
    		if ($field->getListId() == $name) {
    			$cnt = $cnt + $userBean->getCountUsedFieldValue(
    					$field->getTableName(), $field->getColumnName(), $title_id);
    		}
    	}
		return $cnt;
	}
	
	/**
	 * get max 
	 * 
	 * @param  var $name:selectname
	 *          var $col:colname
	 * @return array
	 */
	public function getMax($name, $col) {
		$sql = "SELECT MAX($col) FROM $this->table WHERE select_name=" . Xoonips_Utils::convertSQLStr($name);
		$result = $this->execute($sql);
		$max = $this->fetchRow($result);
		if ($max[0] > 0) {
			return $max[0];
		}
		return 0;
	}
	
	/**
	 * insert value
	 * 
	 * @param  var $value;value
	 * @return array
	 */
	public function insertValue($value) {
		$ret = true;
		$sql = "INSERT INTO $this->table (select_name,title_id,title,weight)";
		$sql = $sql . ' VALUES(' . Xoonips_Utils::convertSQLStr($value['select_name']) . ',' . Xoonips_Utils::convertSQLStr($value['title_id']);
		$sql = $sql . ',' . Xoonips_Utils::convertSQLStr($value['title']). ',' . Xoonips_Utils::convertSQLNum($value['weight']) . ')';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return $ret;
	}
	
	/**
	 * update value
	 * 
	 * @param  var value:value
	 * @return boolean
	 */
	public function updateValue($value) {
		$ret = true;
		$sql = "UPDATE $this->table set title=" . Xoonips_Utils::convertSQLStr($value['title']);
		$sql .= ', title_id=' . Xoonips_Utils::convertSQLStr($value['title_id']);
		$sql .= ' WHERE select_name =' . Xoonips_Utils::convertSQLStr($value['select_name']);
		$sql .= ' AND title_id=' . Xoonips_Utils::convertSQLStr($value['title_id_db']);
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return $ret;
	}
}

