<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanBase.class.php';

/**
 * @brief operate avatar table 
 *
 */
class User_AvatarBean extends Xoonips_BeanBase {
	
	/**
	 * Constructor
	 **/
	public function User_AvatarBean($dirname, $trustDirname) {
		$this->Xoonips_BeanBase($dirname, $trustDirname);
		$this->setTableName('avatar');
	}
	
	/**
	 * get avatar file
	 * 
	 * @param
	 * @return array
	 */	
	public function getAvatarFile() {		
		$ret = array();		
		$sql = "SELECT avatar_file,avatar_name FROM $this->table";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[$row['avatar_file']] = $row['avatar_name'];
		}
		$this->freeRecordSet($result);
		return $ret;
	}
}
