<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . '/legacy/class/interface/WorkflowClientDelegateInterface.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/WorkflowFactory.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';

class User_DelegateFunctions { // implements Legacy_iWorkflowClientDelegate
	/**
	 * updateStatus
	 *
	 * @param bool &$result
	 * @param string $dirname
	 * @param string $dataname
	 * @param int $id
	 *
	 * @return	void
	 */ 
	public function updateStatus(/*** bool ***/ &$result, /*** string ***/ $type_id, /*** string ***/ $module, /*** int ***/ $id, /*** int ***/ $status, /*** string ***/ $comment = '') {
		$temp = explode ('.', $module);
		$dirname = $temp[0];
		$c = $temp[1];
		$handler =& xoops_gethandler('module');
		$module =& $handler->getByDirname($dirname);
		$trustDirname = $module->get('trust_dirname');
		if ($trustDirname == USER_TRUST_DIRNAME) {
			$workflow = Xoonips_WorkflowFactory::getWorkflow($c, $dirname, $trustDirname);
			if ($status == Lenum_WorkflowStatus::FINISHED) {
				$workflow->doCertify($id, $result, $comment);
			} elseif ($status == Lenum_WorkflowStatus::PROGRESS) {
				$workflow->doProgress($id, $result, $comment);
			} elseif ($status == Lenum_WorkflowStatus::REJECTED) {
				$workflow->doRefuse($id, $result, $comment);
			}
		}
	}
	
	public function getDetailView(/*** string ***/ &$result, /*** string ***/ $type_id, /*** string ***/ $module, /*** int ***/ $id ) {
		$temp = explode ('.', $module);
		$dirname = $temp[0];
		$c = $temp[1];
		$handler =& xoops_gethandler('module');
		$module =& $handler->getByDirname($dirname);
		$trustDirname = $module->get('trust_dirname');
		if ($trustDirname == USER_TRUST_DIRNAME) {
			$workflow = Xoonips_WorkflowFactory::getWorkflow($c, $dirname, $trustDirname);
			$result .= $workflow->getDetailView($id);
		}
	}
	
	public function getTargetGroupId(/*** string ***/ &$result, /*** string ***/ $type_id, /*** string ***/ $module, /*** int ***/ $id ) {
		$temp = explode ('.', $module);
		$dirname = $temp[0];
		$c = $temp[1];
		$handler =& xoops_gethandler('module');
		$module =& $handler->getByDirname($dirname);
		$trustDirname = $module->get('trust_dirname');
		if ($trustDirname == USER_TRUST_DIRNAME) {
			$workflow = Xoonips_WorkflowFactory::getWorkflow($c, $dirname, $trustDirname);
			$groupsUsersLinkBean = null;
			list($groupid, $uid) = $workflow->getTargetGroupId($id, $groupsUsersLinkBean);
			$result .= $groupid;
		}
	}
}

