<?php

require_once dirname(dirname(__FILE__)) . '/class/core/ActionBase.class.php';
require_once dirname(dirname(__FILE__)) . '/class/core/User.class.php';

class User_UserSuAction extends User_ActionBase {

	protected function doInit(&$request, &$response) {

		$this->checkLoginUser();

		if (isset($_SESSION['xoonips_old_uid'])) {
			redirect_header(XOOPS_URL. '/', 0, ''); // already in su-mode
			exit();
		}

		$userid = $request->getParameter('uid');

		$uname = '';
		$name = '';
		if ($userid !='') {
			$userbean = Xoonips_BeanFactory::getBean('UsersBean', $this->dirname, $this->trustDirname);
			$user = $userbean->getUserBasicInfo($userid);
			$uname = $user['uname'];
			$name = $user['name'];
		}

		$breadcrumbs = array(
			array(
	            'name' => _MD_USER_LANG_SU,
			)
		);

		$viewData['xoops_breadcrumbs'] = $breadcrumbs;
		$viewData['su_uid'] = $userid;
		$viewData['uname'] = $uname;
		$viewData['name'] = $name;
		$viewData['dirname'] = $this->dirname;
		$response->setViewData($viewData);
		$response->setForward('init_success');
		return true;
	}

	protected function doSu(&$request, &$response) {

		$this->checkLoginUser();

		$su_uid = $request->getParameter('su_uid');
		$password = $request->getParameter('password');

		//account is required
		if ($su_uid =='') {
			redirect_header('index.php?action=userSu', 3, _MD_USER_MESSAGE_SU_NO_ACCOUNT);
		}

		$uid = $_SESSION['xoopsUserId'];

		global $xoopsDB;
		// check admin password
		$sql = 'select uid from ' . $xoopsDB->prefix('users') . " where uid=$uid and pass='" . md5($password) . "'";
		$result = $xoopsDB->query($sql);
		if ($result == FALSE || $xoopsDB->getRowsNum($result) == 0) {
			$url = 'index.php?action=userSu&uid=' . $su_uid;
			redirect_header($url, 3, _MD_USER_MESSAGE_SU_FAIL);
		}
		
		$user = User_User::getInstance();
		if (!$user->checkLoginImpl($su_uid, false)) {
			exit();
		}
		
		// su
		$_SESSION['xoonips_old_uid'] = $uid;
		$this->changeUid($su_uid);

		XCube_DelegateUtils::call("Module.User.Event.User.Substitute.Begin",new XoopsUser($uid), new XoopsUser($su_uid));

		redirect_header(XOOPS_URL . '/', 3, _MD_USER_MESSAGE_SU_START);
		exit();
	}

	protected function doEnd(&$request, &$response) {
		$this->checkLoginUser();
		$uid = $_SESSION['xoopsUserId'];
		if ( isset($_SESSION['xoonips_old_uid'])) {
			XCube_DelegateUtils::call("Module.User.Event.User.Substitute.End",new XoopsUser($_SESSION['xoonips_old_uid']),new XoopsUser($uid));			
			global $xoopsDB;

			$this->changeUid($_SESSION['xoonips_old_uid']);
			$_SESSION['xoonips_old_uid'] = null;

			redirect_header(XOOPS_URL . '/', 3, _MD_USER_MESSAGE_SU_END);
			exit();
		} else {
			redirect_header(XOOPS_URL . '/', 0, ''); // not in su-mode
			exit();
		}
	}

	// check login user
	private function checkLoginUser() {
		// reject non-xoops-admin
		global $xoopsUser;
		if (is_object($xoopsUser)) {
			if (!$xoopsUser->isAdmin(-1) && !isset($_SESSION['xoonips_old_uid'])) {
				redirect_header( XOOPS_URL . '/', 2 ,_MD_USER_ITEM_FORBIDDEN);
				exit();
			}
		} else {
			redirect_header(XOOPS_URL . '/user.php', 2, _MD_USER_ITEM_FORBIDDEN);
			exit();
		}
	}

	// change uid.
	// don't preserve old uid.
	private function changeUid($su_uid) {
		$u = new XoopsUser($su_uid);
		$groupids = $u->getGroups();
		$_SESSION['xoopsUserId'] = $su_uid;
		$_SESSION['xoopsUserGroups'] = $groupids;
	}
}

