package lib.xlsx.bookDefine;

import java.security.InvalidParameterException;
import java.util.*;

public class Sheet {
	private ArrayList<Row> rowList;
	private String sheetName;

	public Sheet() {
		rowList = new ArrayList<Row>();
		sheetName = null;
	}
	public Sheet(String sheetName) {
		rowList = new ArrayList<Row>();
		this.sheetName = sheetName; 
	}
	
	public void setValue(int rowNum, int colNum, String value) {
		if(rowNum < 1) {
			throw new InvalidParameterException("rowNum >= 1");
		}
		if(colNum < 1) {
			throw new InvalidParameterException("colNum >= 1");
		}
		if(rowList.size() < rowNum) {
			int len = rowNum - rowList.size();
			for(int i = 0; i < len;i++) {
				rowList.add(new Row());
			}
		}
		rowNum--;
		colNum--;
		rowList.get(rowNum).setCellValue(colNum, value);
	}
	
	public void setValue(int rowNum, int colNum, int value) {
		if(rowNum < 1) {
			throw new InvalidParameterException("rowNum >= 1");
		}
		if(colNum < 1) {
			throw new InvalidParameterException("colNum >= 1");
		}
		if(rowList.size() < rowNum) {
			int len = rowNum - rowList.size();
			for(int i = 0; i < len;i++) {
				rowList.add(new Row());
			}
		}
		rowNum--;
		colNum--;
		rowList.get(rowNum).setCellValue(colNum, value);
	}
	
	/**
	 * mۂĂs̐is܂ށj擾
	 * @return s̐
	 */
	public int rowLength() {
		return rowList.size();
	}
	
	public Row getRow(int rowNum) {
		if(rowNum < 1) {
			throw new InvalidParameterException("rowNum is less than '0'");
		}
		rowNum--;
		return rowList.get(rowNum);
	}

	/**
	 * s̏o
	 */
	@Override
	public String toString() {
		return rowList.toString();
	}
	public String getSheetName() {
		return sheetName;
	}
	public void setSheetName(String name) {
		this.sheetName = name;
	}
}
