﻿using System;
using System.Printing;
using System.Runtime.InteropServices;
using System.Windows;


namespace com.dnetopen.MsOffice.Printer
{

    /// <summary>
    /// プリンタのプロパティを呼び出す
    /// </summary>
    /// <参考>
    /// Usa*Usa日記
    /// http://d.hatena.ne.jp/machi_pon/20061004/1159953490
    /// </参考>
    public class PrinterSettingDialog
    {
        [DllImport("winspool.drv", SetLastError = true)]
        static extern bool OpenPrinter(string pPrinterName, out IntPtr phPrinter, IntPtr pDefault);
        [DllImport("winspool.drv", SetLastError = true)]
        static extern int ClosePrinter(IntPtr hPrinter);
        [DllImport("winspool.drv", EntryPoint = "DocumentPropertiesW", SetLastError = true, ExactSpelling = true, CallingConvention = CallingConvention.StdCall)]
        static extern int DocumentProperties(IntPtr hwnd, IntPtr hPrinter, [MarshalAs(UnmanagedType.LPWStr)] string pDeviceName, IntPtr pDevModeOutput, IntPtr pDevModeInput, int fMode);

        /// <summary>
        /// プリンタ設定のプロパティを呼び出す
        /// </summary>
        /// <param name="hwnd"></param>
        /// <param name="ps"></param>
        /// <returns></returns>
        public static bool ShowProperties(IntPtr hwnd, System.Drawing.Printing.PrinterSettings ps)
        {
            IntPtr hPrt = IntPtr.Zero;
            IntPtr hDevMode = ps.GetHdevmode(ps.DefaultPageSettings);
            IntPtr pDevModeInput = Marshal.AllocHGlobal(hDevMode);

            if (OpenPrinter(ps.PrinterName, out hPrt, IntPtr.Zero) == false)
            {
                return (false);
            }
            if (hPrt == IntPtr.Zero)
            {
                return (false);
            }

            int size = DocumentProperties(hwnd, hPrt, ps.PrinterName, IntPtr.Zero, IntPtr.Zero, 0);
            IntPtr pDevModeOutput = Marshal.AllocHGlobal(size);

            int ret = DocumentProperties(hwnd, hPrt, ps.PrinterName, pDevModeOutput, pDevModeInput, 14);
            if (ret == 1)
            {
                ps.SetHdevmode(pDevModeOutput);
            }

            Marshal.FreeHGlobal(pDevModeOutput);
            Marshal.FreeHGlobal(pDevModeInput);
            ClosePrinter(hPrt);
            if (ret == 1)
            {
                return true;
            }
            else
            {
                return false;
            }

        }
    }
}
