﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace com.dnetopen.MsOffice.MODIWSetting
{
    public class RegstSettingWriter
    {
        public static void WriteRegistry(RegstSettingValues val)
        {
            string key = RegstChecker.GetLatestRegistryKey();
            if (key == null)
            {
                throw new ApplicationException("MODI関連のRegistryが見つかりません。");
            }
            WriteRegistry(key, val);
        }

        public static void WriteRegistry(string regKey, RegstSettingValues val)
        {
            Microsoft.Win32.Registry.SetValue(regKey, "COMPIMGEMF", (int)val.MdiCompImg,Microsoft.Win32.RegistryValueKind.DWord);
            Microsoft.Win32.Registry.SetValue(regKey, "DefaultFolder", val.DefaultFolder, Microsoft.Win32.RegistryValueKind.String);
            Microsoft.Win32.Registry.SetValue(regKey, "PrivateFlags", (int)val.OutputFileType, Microsoft.Win32.RegistryValueKind.DWord);
            Microsoft.Win32.Registry.SetValue(regKey, "Public_PaperSize", val.PaperSize, Microsoft.Win32.RegistryValueKind.DWord);
            Microsoft.Win32.Registry.SetValue(regKey, "Public_Orientation", val.PaperOrientation, Microsoft.Win32.RegistryValueKind.DWord);
            Microsoft.Win32.Registry.SetValue(regKey, "TIFDPI", val.TiffDpi, Microsoft.Win32.RegistryValueKind.DWord);
            Microsoft.Win32.Registry.SetValue(regKey, "OpenInMODI", val.PrintAfterAppStart, Microsoft.Win32.RegistryValueKind.DWord);    
        }
    }
}
