package sql.mirroring;

import hiro.yoshioka.sql.engine.MirroringRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.RequestAdaptor;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.twitter.TwitterSchemaType;
import hiro.yoshioka.sql.resource.twitter.TwitterTableType;

public class MirroringFromTwitterToMySQLTest extends AbsMirroringTest {

	@Override
	void setUpMirroringConnection() {
		for (ConnectionProperties p : bean.getConnectionSet()) {
			if (p.getDatabaseType().isTwitter()) {
				this.mirroring_from_con_properties = p;
			} else if (p.getDatabaseType().isMySQL()) {
				this.mirroring_to_con_properties = p;
			}
		}
	}

	public void testMirroringFollowers() {
		MirroringRequest request = new MirroringRequest(
				this.mirroring_from_con_properties,
				this.mirroring_to_con_properties);
		request.dropSchema = true;
		request.dropTable = true;
		request.cascade = true;
		request.makeBlob = true;
		request.putSchemaMapping(TwitterSchemaType.Followers.name(),
				TwitterSchemaType.Followers.name());
		request.putMirroringTable(TwitterSchemaType.Followers.name(),
				TwitterTableType.FollowersIDs.name(), true);

		request.putSchemaMapping(TwitterSchemaType.Timeline.name(),
				TwitterSchemaType.Timeline.name());
		for (TwitterTableType tableType : TwitterTableType
				.getTableTypeListOf(TwitterSchemaType.Timeline)) {
			request.putMirroringTable(TwitterSchemaType.Timeline.name(),
					tableType.name(), true);
		}

		// accounts
		request.putSchemaMapping(TwitterSchemaType.Account.name(),
				TwitterSchemaType.Account.name());
		for (TwitterTableType tableType : TwitterTableType
				.getTableTypeListOf(TwitterSchemaType.Account)) {
			request.putMirroringTable(TwitterSchemaType.Account.name(),
					tableType.name(), true);
		}

		// DirectMessages
		request.putSchemaMapping(TwitterSchemaType.DirectMessage.name(),
				TwitterSchemaType.DirectMessage.name());
		for (TwitterTableType tableType : TwitterTableType
				.getTableTypeListOf(TwitterSchemaType.DirectMessage)) {
			request.putMirroringTable(TwitterSchemaType.DirectMessage.name(),
					tableType.name(), true);
		}

		request.addListener(new RequestAdaptor() {
			@Override
			public void beginTask(String taskName, int row) {
				System.out.println(String.format("  BEGINE %s [%d]", taskName,
						row));
			}

			@Override
			public void subTask(String subTaskName) {
				System.out.println(String.format("  SUB_TASK %s", subTaskName));
			}

			@Override
			public void called_done(Request request,
					SQLOperationType operation,
					ConnectionProperties properteis, Object o) {
				System.out.println(String.format("  DONE %s [%s]", operation,
						properteis.getDisplayString()));
			}
		});
		assertTrue("Mirroring Success",
				SQLServerThread.runNowThisRequest(request));
	}

}
