package hiro.yoshioka.sql.params;

import hiro.yoshioka.util.StringUtil;

public class DBConnectionInitialItem {
	public String fDriverName = StringUtil.EMPTY_STRING;

	public String fUser = StringUtil.EMPTY_STRING;

	public String fPassWord = StringUtil.EMPTY_STRING;

	public String fDisplayString = StringUtil.EMPTY_STRING;

	public String fURL;

	public String fDriverFilePath;

	public String fInternalLogon;

	public boolean fDBMS;

	public DBConnectionInitialItem(String driverName, String user,
			String password, String display) {
		fDriverName = driverName;
		fUser = user;
		fPassWord = password;
		fDisplayString = display;
	}

	private DBConnectionInitialItem() {
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof DBConnectionInitialItem) {
			DBConnectionInitialItem target = (DBConnectionInitialItem) obj;
			if (!StringUtil.nvl(fDriverName).equals(target.fDriverName)) {
				return false;
			}
			if (!StringUtil.nvl(fUser).equals(target.fUser)) {
				return false;
			}
			if (!StringUtil.nvl(fPassWord).equals(target.fPassWord)) {
				return false;
			}
			if (!StringUtil.nvl(fURL).equals(target.fURL)) {
				return false;
			}
			return true;
		}
		return false;
	}

	public String miniString() {
		return fDisplayString + "->" + fURL + "|" + fUser;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append(fDriverName);
		buf.append("|").append(fUser);
		buf.append("|").append(fPassWord);
		buf.append("|").append(fDisplayString);
		buf.append("|").append(fURL);

		buf.append("|").append(fDriverFilePath);
		buf.append("|").append(fInternalLogon);
		buf.append("|").append(fDBMS);

		return buf.toString();
	}

	public void load(String data) {
		int i = 0;
		String[] datas = data.split("[|]", -1);
		fDriverName = datas[i++];
		fUser = datas[i++];
		fPassWord = datas[i++];
		fDisplayString = datas[i++];
		fURL = datas[i++];
		fDriverFilePath = datas[i++];
		fInternalLogon = datas[i++];
		fDBMS = "true".equals(datas[i++]);
	}

	public static DBConnectionInitialItem loadData(String string) {
		try {
			DBConnectionInitialItem ret = new DBConnectionInitialItem();
			ret.load(string);
			return ret;
		} catch (RuntimeException e) {
		}
		return null;
	}

	public String getWindowTile() {
		if (fDisplayString == null || fDisplayString.length() == 0) {
			return fURL + ":" + fUser;
		}
		return String.format("【%s】%s:%s", fDisplayString, fURL, fUser);
	}
}
