package hiro.yoshioka.sql.notes.reflect;

public enum LevelType {
	LEVEL_NOACCESS(0, "なし"),

	LEVEL_DEPOSITOR(1, "投稿者"),

	LEVEL_READER(2, "読者"),

	LEVEL_AUTHOR(3, "作成者"),

	LEVEL_EDITOR(4, "編集者"),

	LEVEL_DESIGNER(5, "設計者"),

	LEVEL_MANAGER(6, "管理者"),

	ACL_MAX_ROLES(80, "混在グループ"),

	UNKOWN(-999999, "不明");

	private int typeId;
	private String name;

	private LevelType(int typeId, String name) {
		this.typeId = typeId;
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public static LevelType parse(int typeId) {
		for (LevelType target : values()) {
			if (target.typeId == typeId) {
				return target;
			}
		}
		return UNKOWN;
	}

	public int getTypeId() {
		return typeId;
	}
}
