package hiro.yoshioka.sql.engine;

import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.IDBResource;

public class GettingResourceRequest extends Request {
	public enum GettingTarget {
		ONLY_SCHEMA, ONLY_TABLE, ONLY_SELECTED_RESOURCE, ALL;

		public boolean isOnlySchema() {
			return ONLY_SCHEMA.equals(this);
		}

		public boolean isOnlyTable() {
			return ONLY_TABLE.equals(this);
		}

		public boolean isOnlySelectedResouce() {
			return ONLY_SELECTED_RESOURCE.equals(this);
		}

		public boolean isAll() {
			return ALL.equals(this);
		}

	}

	private boolean canceled;

	private boolean fGetComment;

	private boolean fGetIndex;

	private boolean fExportedKeys;

	public GettingTarget targetType = GettingTarget.ALL;

	public boolean fCaptionForignKey;

	public IDBResource selectionResource;

	public GettingResourceRequest(ConnectionProperties connection) {
		this(connection, SQLOperationType.RESOURCE_CAPTION);
	}

	public GettingResourceRequest(ConnectionProperties connection,
			SQLOperationType operationType) {
		super(operationType, connection);
	}

	public boolean isLimitedCaptionRequest() {
		return !targetType.isAll();
	}

	public boolean doGetComment() {
		return fGetComment;
	}

	public void setFGetComment(boolean getComment) {
		fGetComment = getComment;
	}

	public void setExportedKeys(boolean getForignKey) {
		fExportedKeys = getForignKey;
	}

	public boolean doGetIndex() {
		return fGetIndex;
	}

	public void setFGetIndex(boolean getIndex) {
		fGetIndex = getIndex;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("PATTERN [S/T/P] [");
		// buf.append(getSchemaP()).append("/");
		// buf.append(getTableP()).append("/");
		// buf.append(getProcedureP());
		buf.append("]");
		return buf.toString();
	}

	@Override
	protected Object getDoneArgObject() {
		return SQLServerThread.getSQLServer().getTransactionSQL(properties)
				.getRoot();
	}

	public boolean doGetExportedKeys() {
		return fExportedKeys;
	}

	public synchronized void cancel() {
		canceled = true;
	}

	public synchronized boolean canceld() {
		return canceled;
	}

}