package hiro.yoshioka.sql.engine;

import hiro.yoshioka.sdh.BindObject;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.IDBTable;

import java.util.Map;

public class DataGenerateRequest extends Request {
	protected IDBTable table;

	protected String tableName;

	private Map<String, BindObject> insertValuesMap;

	public DataGenerateRequest(ConnectionProperties properties, IDBTable table,
			Map<String, BindObject> insertValuesMap) {
		super(SQLOperationType.DATA_GENERATE, properties);
		this.table = table;
		this.insertValuesMap = insertValuesMap;
	}

	public DataGenerateRequest(ConnectionProperties properties,
			String tableName, Map<String, BindObject> insertValuesMap) {
		super(SQLOperationType.DATA_GENERATE, properties);
		this.tableName = tableName;
		this.insertValuesMap = insertValuesMap;
	}

	public String getTableName() {
		if (table == null) {
			return tableName;
		}
		return table.getName();
	}

	public Map<String, BindObject> getInsertValuesMap() {
		return insertValuesMap;
	}

	@Override
	public void done() {
		super.done();
		if (table != null) {
			DBRoot root = this.properties.getDBRootResource();
			if (root != null) {
				root.addRecentryUsedTable(table);
			}
		}
	}

	@Override
	protected Object getDoneArgObject() {
		return null;
	}

}