package hiro.yoshioka.sql.access;

import hiro.yoshioka.sdh.BindObject;
import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sdh.ResultSetMetaCopy;
import hiro.yoshioka.sdh.ResultSetMetaCopy.MetaInfo;
import hiro.yoshioka.sdh.StringRecordData;
import hiro.yoshioka.sdh2.ReflectionPreparedStatement;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.AbsNoSQL;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.SQLExecutionStatus;
import hiro.yoshioka.sql.SqlBasicListener;
import hiro.yoshioka.sql.engine.DataGenerateRequest;
import hiro.yoshioka.sql.engine.GettingResourceRequest;
import hiro.yoshioka.sql.engine.MirroringRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.engine.TwoDatabasesRequest;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.DBUserPass;
import hiro.yoshioka.sql.resource.DBCrossRefference;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.DBSchema;
import hiro.yoshioka.sql.resource.DBTable;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBSequence;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.resource.TableType;
import hiro.yoshioka.sql.resource.access.AccessDBColumn;
import hiro.yoshioka.util.StringUtil;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.IndexData.ColumnDescriptor;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.query.Query;
import com.mongodb.MongoException;

public class MsAccessWithJackcessSQL extends AbsNoSQL {
	static final int COPY_TABLE_BATCH_SIZE = 200;
	private static final String ADMIN = "admin";
	private static final String SCHEMA_NAME_SYSTEMS = "systems";
	public static final String SCHEMA_NAME_USERS = "users";
	Database db;
	Map<String, DBUserPass> dbPassWordMap = new LinkedHashMap<String, DBUserPass>();

	public MsAccessWithJackcessSQL() {
		super();
	}

	public File getMdbFile() {
		return new File(_info.getURLString());
	}

	public DatabaseType getDatabaseType() {
		return DatabaseType.MS_ACCESS_JACKCESS;
	}

	protected DBRoot getMetaData(GettingResourceRequest request)
			throws IOException {
		this.capturing = true;

		if (request.canceld()) {
			return null;
		}
		DBRoot root = new DBRoot();
		try {
			IDBSchema schema = new DBSchema(root);
			schema.setName(SCHEMA_NAME_SYSTEMS);
			root.putResource(schema.getName(), schema);

			for (String name : db.getSystemTableNames()) {
				createTable(schema, name, true);
			}
			addDBTableFromAccessTable(schema, db.getSystemCatalog(), true);
			try {
				addDBTableFromAccessTable(schema, db.getSystemComplexColumns(),
						true);
			} catch (Exception e) {
			}
			// User tables
			schema = new DBSchema(root);
			schema.setName(SCHEMA_NAME_USERS);
			root.putResource(schema.getName(), schema);
			for (String name : db.getTableNames()) {
				createTable(schema, name, false);
			}
			for (Query query : db.getQueries()) {
				addDBQueryFromAccessQuery(schema, query);
			}
			setRoot(root);
			return root;
		} finally {
			capturing = false;
		}
	}

	private void createTable(IDBSchema schema, String name, boolean isSystem)
			throws IOException {
		Table accessTbl = null;
		if (isSystem) {
			accessTbl = db.getSystemTable(name);
		} else {
			accessTbl = db.getTable(name);
		}
		addDBTableFromAccessTable(schema, accessTbl, isSystem);
	}

	private IDBTable addDBTableFromAccessTable(IDBSchema schema,
			Table accessTbl, boolean isSystem) {

		DBTable table = null;

		table = new DBTable(schema);
		if (isSystem) {
			table.setTableType(TableType.SYSTEM_TABLE);
		} else {
			table.setTableType(TableType.TABLE);
		}
		table.setName(accessTbl.getName());
		schema.putTable(table);

		List<ColumnDescriptor> pkColumns = Collections.EMPTY_LIST;
		try {
			pkColumns = accessTbl.getPrimaryKeyIndex().getColumns();
		} catch (Exception e) {
		}
		for (Column col : accessTbl.getColumns()) {
			IDBColumn column = new AccessDBColumn(table, col);
			for (ColumnDescriptor cd : pkColumns) {
				if (cd.getColumn().getName().equals(col.getName())) {
					column.setPKey(true);
					break;
				}
			}
			table.putResource(column.getName(), column);
		}
		return table;
	}

	private ResultSetMetaCopy getResultSetMetaCopy(Table accessTbl)
			throws SQLException {
		List<MetaInfo> metaList = new ArrayList<ResultSetMetaCopy.MetaInfo>();
		for (Column col : accessTbl.getColumns()) {
			MetaInfo mi = new MetaInfo();
			mi.columnName = col.getName();
			mi.columnType = col.getSQLType();
			mi.columnTypeName = col.getType().name();
			mi.tableName = accessTbl.getName();
			// mi.schemaName = SCHEMA_NAME_SYSTEMS;
			mi.scale = col.getScale();
			mi.precision = col.getPrecision();
			metaList.add(mi);
		}
		ResultSetMetaCopy rsm = new ResultSetMetaCopy(metaList);
		return rsm;
	}

	private IDBTable addDBQueryFromAccessQuery(IDBSchema schema, Query query) {
		DBTable table = null;

		table = new DBTable(schema);
		table.setTableType(TableType.VIEW);
		table.setName(query.getName());
		schema.putTable(table);

		for (String parameter : query.getParameters()) {
			Column col = new Column();
			col.setName(parameter);
			col.setType(DataType.TEXT);
			IDBColumn column = new AccessDBColumn(table, col);
			table.putResource(column.getName(), column);
		}
		return table;
	}

	public void addAuthenticate(String dbName, String user, String pass) {
		addAuthenticate(new DBUserPass(dbName, user, pass));
	}

	public void addAuthenticate(DBUserPass dup) {
		if (dup == null) {
			fLogger.warn("Nothing authenticate informain...");
		} else {
			dbPassWordMap.put(dup.db, dup);
			// NotesRunner db = notesRunnerMap.get(dup.db);
		}
	}

	private boolean hasAdminAuthenticate() {
		System.out.println(dbPassWordMap);
		return dbPassWordMap.containsKey(ADMIN);
	}

	public void addUser(String dbname, String username, String passwd) {
		// mongo.getDB(dbname).addUser(username, passwd.toCharArray());
	}

	@Override
	public boolean canDoOperation(SQLOperationType operation) {
		// TODO Auto-generated method stub
		return false;
	}

	public Table getAccessTable(IDBTable table) throws IOException {
		return getAccessTable(table.getName(), table.isSystem());
	}

	public Table getAccessTable(String tableName, boolean isSystem)
			throws IOException {
		if (isSystem) {
			return db.getSystemTable(tableName);
		}
		return db.getTable(tableName);
	}

	public int count(IDBTable table) throws IOException {
		return getAccessTable(table).getRowCount();
	}

	@Override
	public boolean doOperation(SQLOperationType operation, Request request)
			throws SQLException {

		TransactionRequest treq = null;
		setMakeBlobData(request.makeBlob);
		if (request instanceof TransactionRequest) {
			treq = (TransactionRequest) request;
			setMaxRowNum(treq.getMaxRownum());
		}
		ConnectionProperties prop = request.getConnectionProperties();
		long time = System.currentTimeMillis();

		boolean retCode = true;
		try {
			switch (operation) {
			case CONNECT:
				return connect(prop);
			case CLOSE:
				return close();
			case RESOURCE_MIRRORING:
				MirroringRequest mirroring_request = (MirroringRequest) request;
				retCode = createMirroredTableTo(mirroring_request);
				break;
			case DATA_GENERATE:
				DataGenerateRequest dreq = (DataGenerateRequest) request;
				Table accessTbl = getAccessTable(dreq.getTableName(), false);
				InsertCursorWorker worker = new InsertCursorWorker(accessTbl,
						dreq.getInsertValuesMap());
				ResultSetDataHolder2 r2 = worker.execute();
				retCode = (r2.getIntData(0, "InsertCount") > 0);
				break;
			case COUNT:
				int retCount = 0;
				treq.setResultCount(count(treq.getIDBTable()));
				break;
			case RESOURCE_CAPTION:
				getMetaData((GettingResourceRequest) request);
				break;
			case EXPLAIN_PLAN:
				break;
			case SELECT_SESSION:
				break;
			case SELECT_LOCK:
				break;
			case UNID_EXECUTE_QUERY:

			case SELECT_ALL:
				notifyExecute(SQLExecutionStatus.BEFORE_EXECUTE);
				treq.setRDH(getAllData2(treq.getIDBTable(), treq));
				break;
			case CREATE_TRIG_FNC_PROC:
				break;
			case WORST_SQL:
				break;
			case CHECK_VALIDATION:
				break;

			case PREPARED_EXECUTE_QUERY:
				notifyExecute(SQLExecutionStatus.BEFORE_EXECUTE);
				treq.setRDH(getAllData2(treq.getIDBTable(), treq));

				break;

			case PREPARED_EXECUTE:
				break;
			default:
				System.out.println("what's this operation ? " + operation);
				break;
			}
		} catch (Exception e) {
			notifyExecute(SQLExecutionStatus.EXCEPTION, e.getMessage());
			throw cnvSQLException(e);
		}

		return retCode;

	}

	@Override
	public boolean execute(ReflectionPreparedStatement ref) throws SQLException {
		ResultSetDataHolder2 rdh = null;

		try {
			// fLogger.trace("STATEMENT[" + st + "]");
			// ref.setBinds(statement);

			notifyExecute(SQLExecutionStatus.BEFORE_EXECUTE);
			long time = System.currentTimeMillis();

			try {
				Table accessTbl = getAccessTable(ref.getTableName(), false);
				Map<String, BindObject> conditionParamMap = ref
						.getConditionParamsMap();

				MyCursorWorker<ResultSetDataHolder2> worker = null;
				if (ref.isUpdateQuery()) {
					worker = new UpdateCursorWorker(accessTbl,
							ref.getUpdateValuesMap());
					worker.setConditionParamMap(conditionParamMap);
				} else if (ref.isInsertQuery()) {
					worker = new InsertCursorWorker(accessTbl,
							ref.getInsertValuesMap());
				} else if (ref.isDeleteQuery()) {
					worker = new DeleteCursorWorker(accessTbl);
					worker.setConditionParamMap(conditionParamMap);
				}

				rdh = worker.execute();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			time = System.currentTimeMillis() - time;
			notifyExecute(SQLExecutionStatus.AFTER_EXECUTE,
					Boolean.toString(rdh != null), String.valueOf(time));
			// setTransactionTime(true);
		} finally {
		}
		return true;
	}

	@Override
	public ResultSetDataHolder2 getAllData2(IDBTable table, Request request)
			throws SQLException {
		if (request == null) {
			return null;
		}
		int maxRow = Integer.MAX_VALUE;
		List<String> selectionColumnList = null;
		Map<String, BindObject> conditionParamsMap = null;
		List<StringRecordData> orderbyColumnList = null;
		if (request instanceof TransactionRequest) {
			TransactionRequest treq = (TransactionRequest) request;
			maxRow = treq.getMaxRownum();
			selectionColumnList = treq.getSelectColumnList();
			conditionParamsMap = treq.getWhereConditionMap();
			orderbyColumnList = treq.getOrderbyColumnList();
		} else if (request instanceof TwoDatabasesRequest) {

		}

		try {
			Table accessTbl = getAccessTable(table);
			SelectionCursorWorker worker = new SelectionCursorWorker(accessTbl,
					selectionColumnList, orderbyColumnList, maxRow);
			worker.setConditionParamMap(conditionParamsMap);
			return worker.execute();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return null;
	}

	public class DeleteCursorWorker extends
			MyCursorWorker<ResultSetDataHolder2> {
		ResultSetDataHolder2 rdh;

		public DeleteCursorWorker(Table accessTbl) {
			super(accessTbl);
			this.rdh = new ResultSetDataHolder2(new String[] { "DeleteCount" },
					null, DatabaseType.MS_ACCESS_JACKCESS);
		}

		@Override
		public ResultSetDataHolder2 execute() throws IOException {
			int deletecCount = 0;
			Map<String, Object> row = cursor.getNextRow();

			while (row != null) {
				if (isMatchRow(row)) {
					cursor.deleteCurrentRow();
					deletecCount++;
				}
				row = cursor.getNextRow();
			}
			rdh.addRow(new String[] { String.valueOf(deletecCount) });
			return rdh;
		}
	}

	public class InsertCursorWorker extends
			MyCursorWorker<ResultSetDataHolder2> {
		ResultSetDataHolder2 rdh;
		Map<String, BindObject> insertValuesMap;

		public InsertCursorWorker(Table accessTbl,
				Map<String, BindObject> insertValuesMap) {
			super(accessTbl);
			this.insertValuesMap = insertValuesMap;
			this.rdh = new ResultSetDataHolder2(new String[] { "InsertCount" },
					null, DatabaseType.MS_ACCESS_JACKCESS);
		}

		@Override
		public ResultSetDataHolder2 execute() throws IOException {
			int insertedCount = 0;
			List<Object> updateRowList = new ArrayList<Object>();

			for (Column col : accessTbl.getColumns()) {
				if (col.isAutoNumber()) {
					updateRowList.add(Column.AUTO_NUMBER);
				} else {
					boolean doKeep = true;
					if (insertValuesMap.containsKey(col.getName())) {
						BindObject updateValue = insertValuesMap.get(col
								.getName());
						updateRowList.add(updateValue.target);
						doKeep = false;
					}
					if (doKeep) {
						updateRowList.add(Column.KEEP_VALUE);
					}
				}
			}
			accessTbl.addRow(updateRowList.toArray());
			insertedCount++;

			rdh.addRow(new String[] { String.valueOf(insertedCount) });
			return rdh;
		}
	}

	public class UpdateCursorWorker extends
			MyCursorWorker<ResultSetDataHolder2> {
		ResultSetDataHolder2 rdh;
		Map<String, BindObject> updateValuesMap;

		public UpdateCursorWorker(Table accessTbl,
				Map<String, BindObject> updateValuesMap) {
			super(accessTbl);
			this.updateValuesMap = updateValuesMap;
			this.rdh = new ResultSetDataHolder2(new String[] { "UpdateCount" },
					null, DatabaseType.MS_ACCESS_JACKCESS);
		}

		@Override
		public ResultSetDataHolder2 execute() throws IOException {
			// print the data rows
			Map<String, Object> row = cursor.getNextRow();

			String[] keys = rdh.getNoRowKeys();
			int updatedCount = 0;
			while (row != null) {
				if (isMatchRow(row)) {
					updatedCount++;
					System.out.println("rowww::" + row);
					List<Object> updateRowList = new ArrayList<Object>();
					for (Column col : accessTbl.getColumns()) {
						if (col.isAutoNumber()) {
							updateRowList.add(Column.AUTO_NUMBER);
						} else {
							boolean doKeep = true;
							if (updateValuesMap != null
									&& updateValuesMap.size() > 0) {
								if (updateValuesMap.containsKey(col.getName())) {
									BindObject updateValue = updateValuesMap
											.get(col.getName());
									updateRowList.add(updateValue.target);
									doKeep = false;
								}
							}
							if (doKeep) {
								updateRowList.add(Column.KEEP_VALUE);
							}
						}
					}
					System.out.println("upd;" + updateRowList);
					cursor.updateCurrentRow(updateRowList.toArray());
				}
				row = cursor.getNextRow();
			}
			rdh.addRow(new String[] { String.valueOf(updatedCount) });
			return rdh;
		}
	}

	public class SelectionCursorWorker extends
			MyCursorWorker<ResultSetDataHolder2> {
		ResultSetDataHolder2 rdh;
		int maxRow;
		List<StringRecordData> orderbyColumnList;

		public SelectionCursorWorker(Table accessTbl,
				List<String> selectionColumnList,
				List<StringRecordData> orderbyColumnList, int maxRow)
				throws SQLException {
			super(accessTbl);
			this.maxRow = maxRow;
			this.orderbyColumnList = orderbyColumnList;
			ResultSetMetaCopy rsm = getResultSetMetaCopy(accessTbl);
			List<String> selList;
			if (selectionColumnList == null || selectionColumnList.size() == 0) {
				selList = new ArrayList<String>();
				for (Column col : accessTbl.getColumns()) {
					selList.add(col.getName());
				}
			} else {
				selList = selectionColumnList;
			}
			this.rdh = new ResultSetDataHolder2(
					selList.toArray(new String[selList.size()]), rsm,
					DatabaseType.MS_ACCESS_JACKCESS);
		}

		@Override
		public ResultSetDataHolder2 execute() throws IOException {
			// print the data rows
			Map<String, Object> row = cursor.getNextRow();

			String[] keys = rdh.getNoRowKeys();
			while (row != null) {
				if (isMatchRow(row)) {
					int i = 0;
					String[] datas = new String[keys.length];
					for (int j = 0; j < datas.length; j++) {
						datas[j] = "";
						Object obj = row.get(keys[j]);
						if (obj != null) {
							datas[i] = "" + obj;
						}
						i++;
					}
					rdh.addRow(datas);
					if (rdh.getRowCount() >= maxRow) {
						break;
					}
				}
				row = cursor.getNextRow();
			}
			rdh.sort(orderbyColumnList);
			return rdh;
		}
	}

	abstract class MyCursorWorker<T> {
		protected Table accessTbl;
		protected Cursor cursor;
		private Map<String, BindObject> conditionParamMap;

		public MyCursorWorker(Table accessTbl) {
			this.accessTbl = accessTbl;
			this.cursor = Cursor.createCursor(accessTbl);
		}

		public abstract T execute() throws IOException;

		public void setConditionParamMap(
				Map<String, BindObject> conditionParamMap) {
			this.conditionParamMap = conditionParamMap;
		}

		protected boolean isMatchRow(Map<String, Object> targetRow) {
			if (targetRow == null) {
				return false;
			}
			if (conditionParamMap == null || conditionParamMap.size() == 0) {
				return true;
			}
			for (String colName : conditionParamMap.keySet()) {
				Object targetValue = targetRow.get(colName);
				BindObject myValue = conditionParamMap.get(colName);
				if (myValue != null) {
					if (!myValue.accept(targetValue)) {
						return false;
					}
				}
			}
			return true;
		}
	}

	static SQLException cnvSQLException(Throwable e) {
		if (e instanceof ExecutionException) {
			Throwable c = e.getCause();
			if (c instanceof InvocationTargetException) {
				InvocationTargetException iv = (InvocationTargetException) c;
				e = iv.getTargetException();
			}
		}
		SQLException se = new SQLException("AccessSQLException["
				+ e.getLocalizedMessage() + "]", "", e);
		return se;
	}

	public boolean connect(ConnectionProperties properties) throws SQLException {
		this._info = properties;
		addAuthenticate(properties.getAdminAuthenticate());
		addAuthenticate(properties.getAuthenticate());

		boolean ret = true;
		try {
			db = Database.open(getMdbFile());
			System.out.println(db.getDatabaseProperties());
		} catch (IOException e) {
			e.printStackTrace();
			ret = false;
		}

		if (ret && fConnectionListenerList != null) {
			for (SqlBasicListener listener : fConnectionListenerList) {
				listener.connected();
			}
		}
		properties.setConnected(ret);
		return ret;
	}

	@Override
	public boolean close() throws SQLException {
		boolean ret = true;
		try {
			try {
				db.flush();
			} catch (Exception e) {
				e.printStackTrace();
			}
			db.close();
		} catch (IOException e) {
			ret = false;
			e.printStackTrace();
		}
		if (fConnectionListenerList != null) {
			for (SqlBasicListener listener : fConnectionListenerList) {
				listener.disconnected();
			}
		}
		this._info.setConnected(ret);
		return ret;
	}

	// ----------------------------------------------------------------
	// [5] MIRRORING
	// ----------------------------------------------------------------
	@Override
	public boolean supportResultSet() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean createMirroredTableTo_FaseOnSchema(
			MirroringRequest mirroring_request) throws SQLException {
		fLogger.info("start.");

		fLogger.info("end. do nothing.");
		return true;
	}

	@Override
	public boolean createMirroredTableTo_FaseOnTable(
			MirroringRequest mirroring_request) throws SQLException {
		fLogger.info("start ");

		boolean retCode = true;
		for (String mappingFromSchemaName : mirroring_request.getTableMapping()
				.keySet()) {
			Set<MirroringRequest.MirroringTableInfo> tableInfoSet = mirroring_request
					.getTableMapping().get(mappingFromSchemaName);
			String mappingToSchemaName = mirroring_request
					.getMappingToSchemaName(mappingFromSchemaName);
			if (!mappingToSchemaName.equalsIgnoreCase(SCHEMA_NAME_USERS)) {
				fLogger.fatal("map to schema must be users.");
				return false;
			}
			mirroring_request.beginTask(String.format(
					"Table migration start, table total [%d] in [%s] ",
					tableInfoSet.size(), mappingToSchemaName), tableInfoSet
					.size());
			int i = 0;
			for (MirroringRequest.MirroringTableInfo mappingFromTableInfo : tableInfoSet) {
				i++;
				int retCnt = 0;
				try {
					IDBTable mappingFromTable = mappingFromTableInfo
							.getMappingFromDBTable(mappingFromSchemaName);
					boolean existsTable = existsTable(mappingToSchemaName,
							mappingFromTableInfo.name);

					mirroring_request.subTask(String.format(
							"Exists Table Checker... exists[%b]", existsTable));
					if (existsTable && mirroring_request.dropTable) {
						clearTable(mappingFromTable, mirroring_request.cascade);
					}
					if (!existsTable) {
						mirroring_request
								.addResultRecord(new String[] { "TABLE", "-",
										mappingFromTableInfo.name,
										StringUtil.EMPTY_STRING, "×",
										String.valueOf(retCnt),
										"Jackcess can't support create table without English sort order." });
						continue;
					}

					// for table
					ResultSetDataHolder2 rdh = null;
					fLogger.info("" + mappingFromTableInfo);

					try {

						try {
							ResultSet source = mirroring_request
									.getMirroringFromSql().getAllData(
											mappingFromTable);

							ResultSetMetaData md = source.getMetaData();
							Map<String, Integer> accessTblToMetaMap = new java.util.HashMap<String, Integer>();
							Table accessTbl = getAccessTable(
									mappingFromTable.getName(), false);
							List<Column> accessColumnsList = accessTbl
									.getColumns();
							for (int k = 1; k <= md.getColumnCount(); k++) {
								String name = md.getColumnName(k);
								for (Column column : accessColumnsList) {
									if (column.getName().equalsIgnoreCase(name)) {
										accessTblToMetaMap.put(
												column.getName(), k);
										break;
									}
								}
							}

							List<Object> updateRowList = new ArrayList<Object>();
							while (source.next()) {
								for (Column col : accessColumnsList) {
									if (col.isAutoNumber()) {
										updateRowList.add(Column.AUTO_NUMBER);
									} else {
										boolean doKeep = true;
										Integer colPos = accessTblToMetaMap
												.get(col.getName());
										if (colPos != null) {
											Object appendValue = null;
											switch (col.getType()) {
											case TEXT:
											case MEMO:
												appendValue = source
														.getString(colPos);
												break;
											}
											updateRowList.add(appendValue);
											doKeep = false;
										}
										if (doKeep) {
											updateRowList
													.add(Column.KEEP_VALUE);
										}
									}
								}
								accessTbl.addRow(updateRowList.toArray());
								retCnt++;
							}

						} catch (MongoException e) {
							mirroring_request.addResultRecord(new String[] {
									"TABLE", "-", mappingFromTableInfo.name,
									StringUtil.EMPTY_STRING, "×",
									String.valueOf(retCnt), "" });
							retCode = false;
						}
						if (!mirroring_request.continuing) {
							throw new RuntimeException("abort");
						}
						boolean commit_result = commit();
						mirroring_request
								.subTask(String.format(
										"Insert commited... result[%b]",
										commit_result));
						mirroring_request.addResultRecord(new String[] {
								"TABLE", "-", mappingFromTableInfo.name,
								StringUtil.EMPTY_STRING, "○",
								String.valueOf(retCnt), "-" });

					} catch (Exception e) {
						fLogger.warn(StringUtil.EMPTY_STRING, e);
						mirroring_request.addResultRecord(new String[] {
								"TABLE", "-", mappingFromTableInfo.name,
								StringUtil.EMPTY_STRING, "×",
								String.valueOf(retCnt), e.getMessage() });
						mirroring_request.setThrowable(e);
						retCode = false;
					} finally {
					}

					// System.out.println(getAllData2(table));
				} catch (SQLException e) {
					mirroring_request.addResultRecord(new String[] { "TABLE",
							"-", mappingFromTableInfo.name,
							StringUtil.EMPTY_STRING, "×",
							String.valueOf(retCnt), e.getMessage() });
					mirroring_request.setThrowable(e);

					if (!mirroring_request.continuing) {
						throw e;
					}
					rollback();
				} finally {
					mirroring_request.worked(1);
				}
			}
		}

		return retCode;
	}

	private void clearTable(IDBTable table, boolean cascade) {
		Table accessTbl;
		try {
			accessTbl = getAccessTable(table);
			Cursor cursor = Cursor.createCursor(accessTbl);
			Map<String, Object> row = cursor.getNextRow();

			row = cursor.getNextRow();
			while (row != null) {
				cursor.deleteCurrentRow();
				row = cursor.getNextRow();
			}
		} catch (IOException e) {
		}
	}

	@Override
	public String getDefaultSchemaName() {
		return SCHEMA_NAME_USERS;
	}

	public boolean migration(ITransactionSQL osql, DBCrossRefference original,
			boolean drop, boolean cascade) throws SQLException {
		fLogger.fatal("Access db with jackcess is read only...");
		return false;
	}

	public boolean existsTable(String schemaName, String tableName)
			throws SQLException {
		boolean ret = false;
		try {
			ret = db.getTableNames().contains(tableName);
		} catch (IOException e) {
		}
		fLogger.debug("ret=" + ret);
		return ret;
	}

	public boolean migration(ITransactionSQL osql, IDBSequence original,
			boolean drop, boolean cascade, boolean noSchema)
			throws SQLException {
		fLogger.fatal("Access db with jackcess is read only...");
		return false;
	}

	@Override
	public void setTableColumns(String schema, IDBTable table)
			throws SQLException {
		try {
			Table accessTbl = getAccessTable(table);
			List<ColumnDescriptor> pkColumns = Collections.EMPTY_LIST;
			try {
				pkColumns = accessTbl.getPrimaryKeyIndex().getColumns();
			} catch (Exception e) {
			}
			for (Column col : accessTbl.getColumns()) {
				IDBColumn column = new AccessDBColumn(table, col);
				for (ColumnDescriptor cd : pkColumns) {
					if (cd.getColumn().getName().equals(col.getName())) {
						column.setPKey(true);
						break;
					}
				}
				table.putResource(column.getName(), column);
			}
		} catch (IOException e) {
		}
	}

}
