package hiro.yoshioka.ast.sql.util;

import hiro.yoshioka.sql.resource.DBRoot;

import java.io.File;
import java.io.FileNotFoundException;

public class WolfMongoProposalParserFactory extends ProposalParserFactory {

	@Override
	public IProposalableParserUtil createParserUtil(String statement, DBRoot root) {
		return new WolfMongoProposalParserUtil(statement, root);
	}

	@Override
	public IProposalableParserUtil createParserUtil(File file, DBRoot root) {
		try {
			return new WolfMongoProposalParserUtil(file, root);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return null;
	}

}
