package hiro.yoshioka.sql.resource.twitter;

import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.DBSchema;
import hiro.yoshioka.sql.resource.IDBResource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TwitterDBSchema extends DBSchema implements Serializable {
	private static final long serialVersionUID = -1634285768223507722L;
	private TwitterSchemaType schemaType;
	private Map<TwitterSchemaType, List<TwitterUser>> userMap;

	public TwitterDBSchema(DBRoot root, TwitterSchemaType schemaType) {
		super(root);
		this.schemaType = schemaType;
		setName(schemaType.name());
		setComment(schemaType.getSchemaName());
	}

	public TwitterSchemaType getSchemaType() {
		return schemaType;
	}

	@Override
	public List listResources() {
		List list = super.listResources();
		switch (schemaType) {
		case Followers:
			list.addAll(getUserList(TwitterSchemaType.Followers));
			break;
		}
		return list;
	}

	public List<TwitterUser> getUserList(TwitterSchemaType schemaType) {
		if (userMap == null) {
			return Collections.EMPTY_LIST;
		}
		List<TwitterUser> list = userMap.get(schemaType);
		if (list == null) {
			return Collections.EMPTY_LIST;
		}
		return list;
	}

	public void addUser(TwitterSchemaType schemaType, TwitterUser user) {
		if (userMap == null) {
			userMap = new HashMap<TwitterSchemaType, List<TwitterUser>>();
		}
		List<TwitterUser> list = userMap.get(schemaType);
		if (list == null) {
			list = new ArrayList<TwitterUser>();
			userMap.put(schemaType, list);
		}
		list.add(user);
	}

	@Override
	public void setValueFromOld(IDBResource schema) {
		this.schemaType = ((TwitterDBSchema) schema).schemaType;
	}

}