package hiro.yoshioka.sql.resource.evernote;

import hiro.yoshioka.sql.resource.DBColumn.SearchableType;
import hiro.yoshioka.sql.resource.DBDictionaryRoot;
import hiro.yoshioka.sql.resource.DBTable;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBResource;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.util.StringUtil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EvernoteDBTable extends DBTable implements Serializable {
	private static final long serialVersionUID = -7242097468406664802L;
	private EvernoteTableType evernoteTableType;
	private String guid;
	private String uri;
	private String userName;
	private String refferencedGuid;
	private String sharedId;

	public EvernoteDBTable(IDBSchema schema, EvernoteTableType tableType) {
		super(schema);
		this.evernoteTableType = tableType;
		setName(tableType.name());
	}

	public EvernoteDBTable(DBDictionaryRoot droot) {
		super(droot);
	}

	public String getGuid() {
		return guid;
	}

	public void setGuid(String guid) {
		this.guid = guid;
	}

	@Override
	public void setName(String name) {
		name = name.replaceAll(StringUtil.HALF_SPACE__STRING,
				StringUtil.EMPTY_STRING);
		super.setName(name);
	}

	@Override
	public IDBColumn[] getColumnsForSelectionDialog() {
		EvernoteDBSchema parent = (EvernoteDBSchema) getParent();
		List<EvernoteColumnType> clist = EvernoteColumnType
				.getSearchColumnTypeListOf(parent.getSchemaType(),
						this.evernoteTableType);
		if (clist.size() == 0) {
			return super.getColumnsForSelectionDialog();
		}
		List list = new ArrayList();
		for (EvernoteColumnType ct : clist) {
			EvernoteDBColumn column = new EvernoteDBColumn(this, ct);
			column.setName(ct.name());
			column.setConditionParameter(SearchableType.SEARCHABLE_INVISIBLE);
			list.add(column);
		}
		list.addAll(listResources());

		return (IDBColumn[]) list.toArray(new IDBColumn[list.size()]);
	}

	public EvernoteTableType getEvernoteTableType() {
		return evernoteTableType;
	}

	@Override
	public void setValueFromOld(IDBResource tbl) {
		System.out.println("old form=" + evernoteTableType);
		this.evernoteTableType = ((EvernoteDBTable) tbl).evernoteTableType;
	}

	public String getUri() {
		return uri;
	}

	public void setUri(String uri) {
		this.uri = uri;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getRefferencedGuid() {
		return refferencedGuid;
	}

	public void setRefferencedGuid(String refferencedGuid) {
		this.refferencedGuid = refferencedGuid;
	}

	public String getSharedId() {
		return sharedId;
	}

	public void setSharedId(String sharedId) {
		this.sharedId = sharedId;
	}

}