package hiro.yoshioka.sql.resource.evernote;

import hiro.yoshioka.sql.resource.DBColumn.SearchableType;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.util.SQLDataType;
import hiro.yoshioka.util.StringUtil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum EvernoteColumnType {
	// --------------------------------------------------------------------------
	// SEARCH PARAMS
	// --------------------------------------------------------------------------
	/** guid */
	guid("guid", SQLDataType.CHAR, "CHAR", "getGuid", true),
	/** whomUserId */
	whomUserId("whomUserId", SQLDataType.NUMERIC, "LONG", "none"),
	/** exclude */
	exclude("exclude", SQLDataType.BOOLEAN, "BOOLEAN", "none"),
	/** date */
	date("date", SQLDataType.DATE, "DATE", "none"),
	/** search_query */
	search_query("search_query", SQLDataType.VARCHAR, "VARCHAR", "none"),
	// --------------------------------------------------------------------------
	// LINKED_NOTE
	// --------------------------------------------------------------------------
	/** shardId */
	shardId("shardId", SQLDataType.VARCHAR, "VARCHAR", "getShardId"),
	/** shareKey */
	shareKey("shareKey", SQLDataType.VARCHAR, "VARCHAR", "getShareKey"),
	/** shareName */
	shareName("shareName", SQLDataType.VARCHAR, "VARCHAR", "getShareName"),
	/** uri */
	uri("uri", SQLDataType.VARCHAR, "VARCHAR", "getUri"),
	/** username */
	username("username", SQLDataType.VARCHAR, "VARCHAR", "getUsername"),

	// --------------------------------------------------------------------------
	// NOTE
	// --------------------------------------------------------------------------
	/** content */
	content("content", SQLDataType.CLOB, "CLOB", "getContent"),
	/** contentHash */
	contentHash("contentHash", SQLDataType.VARBINARY, "VARBINARY",
			"getContentHash"),
	/** contentLength */
	contentLength("contentLength", SQLDataType.INTEGER, "INTEGER",
			"getContentLength"),
	/** created */
	created("created", SQLDataType.DATE, "DATE", "getCreated"),
	/** deleted */
	deleted("deleted", SQLDataType.DATE, "DATE", "getDeleted"),
	/** notebookGuid */
	notebookGuid("notebookGuid", SQLDataType.CHAR, "CHAR",
			"getNotebookGuid"),
	/** resourcesSize */
	resourcesSize("resourcesSize", SQLDataType.INTEGER, "INTEGER",
			"getResourcesSize"),
	/** resources */
	resources("resources", SQLDataType.STRUCT, "STRUCT", "getResources"),
	/** tagGuids */
	tagGuids("tagGuids", SQLDataType.VARCHAR, "VARCHAR", "getTagGuids"),
	/** tagNames */
	tagNames("tagNames", SQLDataType.VARCHAR, "VARCHAR", "getTagNames"),
	/** title */
	title("title", SQLDataType.VARCHAR, "VARCHAR", "getTitle");

	public static final List<EvernoteColumnType> NOTE_LIST = new ArrayList<EvernoteColumnType>();
	public static final List<EvernoteColumnType> LINKED_NOTE_LIST = new ArrayList<EvernoteColumnType>();

	static {
		NOTE_LIST.add(guid);
		NOTE_LIST.add(title);
		NOTE_LIST.add(content);
		// NOTE_LIST.add(contentHash);
		NOTE_LIST.add(contentLength);
		NOTE_LIST.add(created);
		NOTE_LIST.add(deleted);
		NOTE_LIST.add(notebookGuid);
		NOTE_LIST.add(resourcesSize);
		NOTE_LIST.add(resources);
		NOTE_LIST.add(tagGuids);
		NOTE_LIST.add(tagNames);

		LINKED_NOTE_LIST.add(guid);
		LINKED_NOTE_LIST.add(shardId);
		LINKED_NOTE_LIST.add(shareKey);
		LINKED_NOTE_LIST.add(shareName);
		LINKED_NOTE_LIST.add(uri);
		LINKED_NOTE_LIST.add(username);

	}
	private String columnName;
	private SQLDataType columnType;
	private String dataTypeString;
	private String valueMethod;
	private boolean primaryKey;

	private EvernoteColumnType(String columnName, SQLDataType dataType,
			String dataTypeString, String valueMethod) {
		this(columnName, dataType, dataTypeString, valueMethod, false);
	}

	private EvernoteColumnType(String columnName, SQLDataType dataType,
			String dataTypeString, String valueMethod, boolean primaryKey) {
		this.columnName = columnName;
		this.columnType = dataType;
		this.dataTypeString = dataTypeString;
		this.valueMethod = valueMethod;
		this.primaryKey = primaryKey;
	}

	public boolean isPrimaryKey() {
		return primaryKey;
	}

	public String getColumnName() {
		return columnName;
	}

	public SQLDataType getColumnType() {
		return columnType;
	}

	public String getDataTypeString() {
		return dataTypeString;
	}

	public String getValueMethod() {
		return valueMethod;
	}

	public boolean isOnClickable() {
		switch (this) {
		case uri:
			return true;

		}
		return false;
	}

	public static List<EvernoteColumnType> getColumnTypeListOf(
			EvernoteTableType tableType) {
		switch (tableType) {
		case NoteBook:
			return NOTE_LIST;
		case LinkedNoteBook:
			return LINKED_NOTE_LIST;
		}
		return Collections.EMPTY_LIST;
	}

	public SearchableType getSearchableType() {
		switch (this) {
		case guid:
		case notebookGuid:
			return SearchableType.SEARCHABLE_VISIBLE;
		}
		return SearchableType.UNSEARCHABLE;
	}

	public static List<EvernoteColumnType> getSearchColumnTypeListOf(
			EvernoteSchemaType schemaType, EvernoteTableType tableType) {
		List<EvernoteColumnType> retList;
		// switch (schemaType) {
		// case NoteBook:
		// retList = new ArrayList<EvernoteColumnType>();
		// retList.add(guid);
		// return retList;
		//
		// }
		return Collections.EMPTY_LIST;
	}

	public String getDefaultValue(DBRoot root, EvernoteSchemaType schemaType,
			EvernoteTableType tableType) {
		// switch (schemaType) { }
		return StringUtil.EMPTY_STRING;
	}

}
