package hiro.yoshioka.ast.sql.oracle;

import hiro.yoshioka.ast.sql.AbsSQLParser;
import hiro.yoshioka.ast.sql.AbsSimpleNode;
import hiro.yoshioka.ast.sql.IDML;
import hiro.yoshioka.ast.sql.util.ASTEditorTableListHolder;
import hiro.yoshioka.sql.resource.IDBTable;

import java.util.List;

public abstract class ASTDefaultDML extends SimpleNode implements IDML {

	public ASTEditorTableListHolder fTableHolder = new ASTEditorTableListHolder();

	public int fTable;

	public int fWhere;

	public int fGroupBy;

	public int fHaving;

	public ASTDefaultDML(int id) {
		super(id);
	}

	public ASTDefaultDML(AbsSQLParser p, int id) {
		super(p, id);
	}

	public boolean emptyTableList() {
		return fTableHolder.size() == 0;
	}

	public boolean isDML() {
		return true;
	}

	public IDML getDMLObject() {
		AbsSimpleNode n = getChild(0);

		if (n instanceof ASTSelectBase) {
			n = n.getChild(0);
		}
		return (IDML) n;
	}

	public boolean isSelectStatement() {
		if (this instanceof ASTSelectBase) {
			return true;
		}
		return false;
	}

	/**
	 * @return
	 */
	public String infomatin() {
		return null;
	}

	public void addTable(IDBTable table) {
		if (log.isDebugEnabled()) {
			log.debug("☆☆ADD TABLE[" + table + "]");
		}
		fTableHolder.addTable(table);
	}

	public void addTableList(List list) {
		if (log.isDebugEnabled()) {
			log.debug(this + " ☆☆ADD TABLE List[" + list + "]");
		}
		fTableHolder.addTableList(list);
	}

	public boolean isDDL() {
		return false;
	}

	public boolean isDOL() {
		return false;
	}

	public ASTEditorTableListHolder getEditorTableListHolder() {
		if (this instanceof ASTSelectBase) {
			AbsSimpleNode node = getChild(0);
			if (node instanceof ASTSelectBaseAndUnion) {
				node = node.getChild(0);
				if (node instanceof ASTSelectSecond) {
					node = node.getChild(0);
					if (node instanceof ASTSelectThird) {
						ASTSelectThird third = (ASTSelectThird) node;
						return third.fTableHolder;
					}
				}
			}
		}
		return fTableHolder;
	}
}
