package hiro.yoshioka.sql.resource;

import java.sql.DatabaseMetaData;

public enum ProcedureType {
	/** ReturnsResult[2] */
	ReturnsResult("ReturnsResult", DatabaseMetaData.procedureReturnsResult),
	/** ResultUnknown[0] */
	ResultUnknown("ResultUnknown", DatabaseMetaData.procedureResultUnknown),
	/** NoResult[1] */
	NoResult("NoResult", DatabaseMetaData.procedureNoResult);

	private String typeString;

	private int typeCode;

	private ProcedureType(String typeString, int typeCode) {
		this.typeString = typeString;
		this.typeCode = typeCode;
	}

	public String getTypeString() {
		return typeString;
	}

	public int getTypeCode() {
		return typeCode;
	}

	public boolean isFunctionOrUnknown() {
		return ReturnsResult.equals(this) || ResultUnknown.equals(this);
	}

	public boolean isProcedureOrUnknown() {
		return NoResult.equals(this) || ResultUnknown.equals(this);
	}

	public static ProcedureType parse(String typeString) {
		if ("FUNCTION".equalsIgnoreCase(typeString)) {
			return ReturnsResult;
		}
		if ("PROCEDURE".equalsIgnoreCase(typeString)) {
			return NoResult;
		}
		ProcedureType ret = valueOf(typeString);
		if (ret == null) {

			System.err.println("unkown table type [" + typeString + "]");
			return ResultUnknown;
		}
		return ret;
	}

	public static ProcedureType parse(int typeCode) {
		for (ProcedureType type : values()) {
			if (type.typeCode == typeCode) {
				return type;
			}
		}
		System.err.println("unkown table type [" + typeCode + "]");
		return ResultUnknown;
	}
}
