package hiro.yoshioka.sql.resource;

import hiro.yoshioka.ast.sql.util.ASTExprUtil;

public class DBExprColumn extends DBColumn {
	private static final long serialVersionUID = 99996325406456L;
	private transient Object fASTExpr;

	public DBExprColumn(IDBTable table, Object expr) {
		super(table);
		fASTExpr = expr;
	}

	public Object getASTExpr() {
		return fASTExpr;
	}

	public String toString() {
		// return fASTExpr.informToken(fASTExpr.getFirstToken())
		// +"-" + fASTExpr.informToken(fASTExpr.getLastToken());
		return "" + fASTExpr;
	}

	/**
	 * コンテンツアシスト用文字列返却。 fASTExpr==null?getName():fASTExpr
	 * 
	 * @return アシスト用文字列
	 */
	public String getProposalString() {
		if (fLogger.isDebugEnabled()) {
			fLogger.debug("fASTExpr=" + fASTExpr);
		}
		return ASTExprUtil.getProposalString(this);
	}
}