package hiro.yoshioka.util;

import java.text.Normalizer;
import java.text.Normalizer.Form;

public class NormalizerUtil {
	public enum CharactorType {
		/** 全角文字 */
		FULL_CHARACTORS("[^ -~｡-ﾟ]"),
		/** 半角文字 */
		HALF_CHARACTORS("[ -~｡-ﾟ]"),
		/** 半角記号 */
		HALF_SYMBOL("[-\\:-@\\[-\\`\\{-\\~]"),
		/** 半角カタカナ */
		HALF_KATAKANA("[｡-ﾟ+]"),
		/** 全角カタカナ */
		FULL_KATAKANA("[ァ-ヶ]"),
		/** カタカナ */
		KATAKANA("[ァ-ヶ｡-ﾟ+]"),
		/** ひらがな */
		HIRAGANA("[ぁ-ゞ]"),
		/** 漢字 */
		KANJI("[一-龠]");
		private String regexString;

		private CharactorType(String regexString) {
			this.regexString = regexString;
		}

		public String getContainRegexString() {
			return String.format(".*%s.*", regexString);
		}

		public String getPerfectMatchRegexString() {
			return String.format("^*%s+$", regexString);
		}
	}

	public static void main(String[] args) {
		System.out.println(NormalizerUtil.containCharType("文字コード",
				CharactorType.KATAKANA));
		System.out.println(NormalizerUtil.containCharType("文字コード",
				CharactorType.KANJI));
		System.out.println(NormalizerUtil.containCharType("文字コード",
				CharactorType.HALF_KATAKANA));
		System.out.println(NormalizerUtil.containCharType("文字ｺｰﾄﾞ",
				CharactorType.KATAKANA));
		System.out.println(NormalizerUtil.containCharType("文字ｺｰﾄﾞ1234１２３４",
				CharactorType.HALF_KATAKANA));
		System.out.println(NormalizerUtil.toFullKana("文字ｺｰﾄﾞ1234１２３４"));
	}

	public static boolean containCharType(String targetString,
			CharactorType type) {
		if (StringUtil.isEmpty(targetString)) {
			return false;
		}
		return targetString.matches(type.getContainRegexString());
	}

	public static boolean matchCharType(String targetString, CharactorType type) {
		if (StringUtil.isEmpty(targetString)) {
			return false;
		}
		return targetString.matches(type.getPerfectMatchRegexString());
	}

	public static String toFullKana(String targetString) {
		return Normalizer.normalize(targetString, Form.NFKC);
	}
}
