package hiro.yoshioka.sdh;

import hiro.yoshioka.util.SQLDataType;
import hiro.yoshioka.util.SQLUtil;

import java.math.BigDecimal;

public class BindObject {
	public Object target;
	public SQLDataType type;
	public ConditionOperatorType operator;

	public BindObject(Object target, SQLDataType type) {
		this.target = target;
		this.type = type;
	}

	public BindObject(String targetString, SQLDataType columnType) {
		this.type = columnType;
		if (targetString == null) {
			this.target = null;
		} else {
			switch (columnType) {
			case BIT:
			case BOOLEAN:
				this.target = SQLUtil.getBoolean(targetString);
				break;
			case TIME:
				this.target = SQLUtil.getTime(targetString);
				return;
			case SMALLINT:
				this.target = SQLUtil.getShort(targetString);
				return;
			case INTEGER:
				this.target = SQLUtil.getInteger(targetString);
				return;
			case REAL:
			case FLOAT:
			case BIGINT:
			case NUMERIC:
			case DOUBLE:
			case DECIMAL:
				this.target = SQLUtil.getBigDecimal(targetString);
				return;
			case TIMESTAMP:
				this.target = SQLUtil.getTimeStamp(targetString);
				return;
			case DATE:
				this.target = SQLUtil.getDate(targetString);
				return;
			default:
				if (targetString.length() == 0) {
					this.target = null;
				} else {
					this.target = targetString;
				}
			}

		}
	}

	@Override
	public String toString() {
		return " TAR{" + target + "} TYPE{" + type + "} ";
	}

	public BigDecimal getBigDecimalValue() {
		return parseBigDecimal(this.target);
	}

	private static BigDecimal parseBigDecimal(Object o) {
		if (o instanceof BigDecimal) {
			return (BigDecimal) o;
		}
		if (o == null) {
			return null;
		}
		return new BigDecimal(o.toString());
	}

	public boolean accept(Object targetValue) {
		if (this.operator == null) {
			if (this.target == null) {
				return targetValue == null;
			}
			return this.target.equals(targetValue);
		} else {
			if (this.operator.isNull()) {
				return targetValue == null;
			}
			if (this.operator.isNotNull()) {
				return targetValue != null;
			}
			if (this.target == null || targetValue == null) {
				return false;
			}
			if (this.type.isNumerics()) {
				BigDecimal myBigDecimal = getBigDecimalValue();
				BigDecimal targetBigDecimal = parseBigDecimal(targetValue);
				switch (this.operator) {
				case GreatorEqual:
					return myBigDecimal.compareTo(targetBigDecimal) <= 0;
				case GreatorThan:
					return myBigDecimal.compareTo(targetBigDecimal) < 0;
				case LessEqual:
					return myBigDecimal.compareTo(targetBigDecimal) >= 0;
				case LessThan:
					return myBigDecimal.compareTo(targetBigDecimal) > 0;
				case Equal:
					return myBigDecimal.equals(targetBigDecimal);
				}
			} else if (this.type.isString()) {
				String myString = String.valueOf(target);
				String targetString = String.valueOf(targetValue);
				switch (this.operator) {
				case GreatorEqual:
					return myString.compareTo(targetString) <= 0;
				case GreatorThan:
					return myString.compareTo(targetString) < 0;
				case LessEqual:
					return myString.compareTo(targetString) >= 0;
				case LessThan:
					return myString.compareTo(targetString) > 0;
				case Equal:
					return myString.equals(targetString);
				case Like:
					if(myString.startsWith("%")){ // 後方一致
						myString = myString.substring(1);
						if(myString.endsWith("%")){
							myString = myString.substring(0,myString.length()-1);
							return targetString.indexOf(myString) >=0;
						}
						return targetString.endsWith(myString);
					} else {
						if(myString.endsWith("%")){
							myString = myString.substring(0,myString.length()-1);
							return targetString.indexOf(myString) >=0;
						}
						return targetString.startsWith(myString);
					}
				}
			}
			return false;
		}
	}
}
