package hiro.yoshioka.wolfcsveditor;

import hiro.yoshioka.csveditor.view.CDHDiffView;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "WolfCSVEditor";

	// The shared instance
	private static Activator plugin;

	/**
	 * The constructor
	 */
	public Activator() {
	}

	public static IWorkbenchPage getWorkbenchPage() {
		IWorkbench w = PlatformUI.getWorkbench();
		if (w != null) {
			IWorkbenchWindow win = w.getActiveWorkbenchWindow();

			if (win != null) {
				return win.getActivePage();
			}
			IWorkbenchWindow[] wins = w.getWorkbenchWindows();
			if (wins.length > 1) {
				System.out.println("+[Window]---"); //$NON-NLS-1$
				for (int i = 0; i < wins.length; i++) {
					System.out.println("+-" + wins[i]); //$NON-NLS-1$
				}
			}
		}
		return null;
	}

	public static CDHDiffView showAndCreateDiffRstView(String secondId) {
		IWorkbenchPage page = getWorkbenchPage();
		if (page != null) {
			try {
				return (CDHDiffView) page.showView(CDHDiffView.ID, secondId,
						IWorkbenchPage.VIEW_ACTIVATE);
			} catch (PartInitException e) {
				e.printStackTrace();
			}
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext
	 * )
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext
	 * )
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 * 
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given plug-in
	 * relative path
	 * 
	 * @param path
	 *            the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}
}
