package hiro.yoshioka.csveditor;

import hiro.yoshioka.csveditor.dialog.CSVConfigDialog;
import hiro.yoshioka.csveditor.dialog.CSVConfigDialog.MyCsvConfig;
import hiro.yoshioka.eclipse.core.CoreUtil;
import hiro.yoshioka.sdh.CDHTableViewer;
import hiro.yoshioka.sdh.CSVRecordDataHolder;
import hiro.yoshioka.sdh.StringRecordData;
import hiro.yoshioka.util.CSVUtil;
import hiro.yoshioka.util.FileUtil;
import hiro.yoshioka.util.StringUtil;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class CSVRDHView extends EditorPart {
	protected Log log = LogFactory.getLog(getClass());
	CDHTableViewer fViewer;
	ToolBar toolbar;
	MyCsvConfig config = new MyCsvConfig(
			CSVUtil.QUOTE_DOUBLE_QUOTE_SEPARATE_TAB);
	Shell shell;
	CSVRecordDataHolder fCSVRecordDataHolder;
	char latestLayout = 'h';

	public CSVRecordDataHolder getInput() {
		return fCSVRecordDataHolder;
	}

	public String getInputString() {
		return fCSVRecordDataHolder.toCSV(config, config.isWithRowColumn());
	}

	public void setPartName(String partName) {
		super.setPartName(partName);
	}

	public int[] getSelectionIndices() {
		return fViewer.getTable().getSelectionIndices();
	}

	public CSVRDHView() {
		super();
	}

	public void doSave(IProgressMonitor monitor) {
	}

	public void doSaveAs() {
	}

	public void init(IEditorSite site, IEditorInput input)
			throws PartInitException {
		setSite(site);
		setInput(input);

		if (input != null) {
			setPartName("Sheet");
		}

	}

	public boolean isDirty() {
		return false;
	}

	public boolean isSaveAsAllowed() {
		return false;
	}

	public void createPartControl(Composite parent) {
		try {
			shell = parent.getShell();
			Composite mainPanel = new Composite(parent, SWT.NONE);
			GridLayout gd = new GridLayout();
			gd.horizontalSpacing = 0;
			gd.marginHeight = 0;
			gd.marginWidth = 0;
			gd.verticalSpacing = 0;
			mainPanel.setLayout(gd);
			fViewer = new CDHTableViewer(mainPanel, SWT.BORDER | SWT.MULTI
					| SWT.FULL_SELECTION | SWT.HIDE_SELECTION | SWT.H_SCROLL
					| SWT.V_SCROLL | SWT.VIRTUAL);
			fViewer.getTable().setLayoutData(new GridData(GridData.FILL_BOTH));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	FileEditorInput getfileEditorInput() {
		if (getEditorInput() instanceof FileEditorInput) {
			return (FileEditorInput) getEditorInput();
		}
		return null;
	}

	@Override
	protected void setInput(IEditorInput input) {
		try {
			super.setInput(input);
			if (getEditorInput() instanceof FileEditorInput) {
				FileEditorInput fi = (FileEditorInput) getEditorInput();
				String target = FileUtil.getText(fi.getFile().getContents(), fi
						.getFile().getCharset(), 5000);
				char c = CSVUtil.getFrequentlyAppearingSeparetor(target);
				config.setSeparator(c);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	public void refreshFromEditorInput() {
		if (getEditorInput() instanceof FileEditorInput) {
			FileEditorInput fi = (FileEditorInput) getEditorInput();
			try {
				config.setEncoding(fi.getFile().getCharset());
				String[][] lists = CSVUtil.split(
						CoreUtil.cnvFile(fi.getFile()), config.getEncoding(),
						config);
				resetCsvRecordDataHolder(lists);
			} catch (CoreException e) {
				e.printStackTrace();
			}
		}

	}

	public void refreshFromString(String target) {
		String[][] lists = CSVUtil.split(target, config);
		resetCsvRecordDataHolder(lists);
	}

	private void resetCsvRecordDataHolder(String[][] lists) {
		if (lists.length > 0) {
			boolean ignoreFirstRowColumn = false;
			if (config.isIgnoreFirstRowColumn()) {
				if (lists[0].length > 0) {
					if ("ROW".equalsIgnoreCase(lists[0][0])) {
						ignoreFirstRowColumn = true;
						lists[0] = Arrays.copyOfRange(lists[0], 1,
								lists[0].length);
					}
				}
			}
			fCSVRecordDataHolder = new CSVRecordDataHolder(lists[0]);
			for (int i = 1; i < lists.length; i++) {
				if (ignoreFirstRowColumn) {
					lists[i] = Arrays.copyOfRange(lists[i], 1, lists[i].length);
				}
				fCSVRecordDataHolder.addRow(lists[i]);
			}
		} else {
			fCSVRecordDataHolder = new CSVRecordDataHolder(
					StringUtil.EMPTY_STRING_ARRAY);
		}
		adjustHeader();
	}

	public void setFocus() {
		fViewer.getTable().setFocus();
	}

	public void adjustDatum() {
		try {
			latestLayout = 'd';
			fViewer.setInputAdjustDatum(fCSVRecordDataHolder);
			// for (org.eclipse.swt.widgets.TableColumn col : fViewer.getTable()
			// .getColumns()) {
			// System.out.println("size-" + col.getWidth());
			// col.pack();
			// System.out.println("size-" + col.getWidth());
			// }
			fViewer.getTable().redraw();
		} catch (RuntimeException e) {
			e.printStackTrace();
		}
	}

	public void adjustHeader() {
		try {
			latestLayout = 'h';
			fViewer.setInputAdjustHeader(fCSVRecordDataHolder);

			// fViewer.getTable().redraw();
		} catch (RuntimeException e) {
			e.printStackTrace();
		}
	}

	protected void adjustSame() {
		switch (latestLayout) {
		case 'a':
			adjustArea();
			break;
		case 'd':
			adjustDatum();
			break;
		default:
			adjustHeader();
		}
	}

	public void adjustArea() {
		try {
			latestLayout = 'a';
			fViewer.setInputAdjustArea(fCSVRecordDataHolder);

			// fViewer.getTable().redraw();
		} catch (RuntimeException e) {
			e.printStackTrace();
		}
	}

	public void selectAll() {
		fViewer.getTable().selectAll();
	}

	public void lostFocus() {
		if (log.isDebugEnabled()) {
			log.debug("focus lost");
		}
		fViewer.cancelEditing();

	}

	public void openConfigDialog() {
		CSVConfigDialog dialog = new CSVConfigDialog(shell, config);
		if (dialog.open() == CSVConfigDialog.OK) {
			config = dialog.getConfig();
			FileEditorInput fi = getfileEditorInput();
			if (fi != null) {
				try {
					fi.getFile().setCharset(config.getEncoding(),
							new NullProgressMonitor());
				} catch (CoreException e1) {
					e1.printStackTrace();
				}
			}
			refreshFromEditorInput();
		}
	}

	public void deleteRow() {
		int[] sels = getSelectionIndices();
		if (sels.length > 0) {
			if (sels.length == 1) {
				StringRecordData[] row = fCSVRecordDataHolder
						.getStringRecordRow(sels[0]);
				String message = null;
				String first = StringUtil.cutByBytes(row[1].getString(), 15,
						Charset.defaultCharset());
				if (row.length >= 2) {
					String second = StringUtil.cutByBytes(
							row[row.length - 1].getString(), 15,
							Charset.defaultCharset());
					message = String.format("Delete Row at [%d][%s...%s] ",
							(sels[0] + 1), first, second);
				} else {
					message = String.format("Delete Row at [%d][%s]",
							(sels[0] + 1), first);
				}
				if (MessageDialog.openQuestion(shell, "Delete Row", message)) {
					fCSVRecordDataHolder.deleteRow(sels[0]);
					adjustSame();
				}
			} else {
				String message = "Delete Rows at [" + (sels[0] + 1);
				for (int i = 1; i < sels.length; i++) {
					message += "," + (sels[i] + 1);
				}
				message += "]";
				if (MessageDialog.openQuestion(shell, "Delete Row", message)) {
					for (int i = sels.length - 1; i >= 0; i--) {
						fCSVRecordDataHolder.deleteRow(sels[i]);
					}
					adjustSame();
				}
			}
		} else {
			int idx = fViewer.getLastSelectedRow();
			if (idx >= 0) {
				StringRecordData[] row = fCSVRecordDataHolder
						.getStringRecordRow(idx);
				String message = null;
				String first = StringUtil.cutByBytes(row[1].getString(), 15,
						Charset.defaultCharset());
				if (row.length >= 2) {
					String second = StringUtil.cutByBytes(
							row[row.length - 1].getString(), 15,
							Charset.defaultCharset());
					message = String.format("Delete Row at [%d][%s...%s]",
							(idx + 1), first, second);
				} else {
					message = String.format("Delete Row at [%d][%s]",
							(idx + 1), first);
				}
				if (MessageDialog.openQuestion(shell, "Delete Row", message)) {
					fCSVRecordDataHolder.deleteRow(idx);
					adjustSame();
				}
			}
		}
	}

	public void distinct(String... keys) {
		fCSVRecordDataHolder.distinct(keys);
		adjustSame();
	}

	public void addRow() {
		int idx = fViewer.getLastSelectedRow();
		int[] sels = getSelectionIndices();
		if (sels.length > 0) {
			idx = sels[0];
		}
		if (idx >= 0) {
			String desc = "Add Row at [" + (idx + 1) + "]";
			InsertDialog dialog = new InsertDialog(shell, "addRow", desc, false);
			if (dialog.open() == Dialog.OK) {
				if (dialog.empty) {
					fCSVRecordDataHolder.addEmptyRow(dialog.before ? idx
							: (idx + 1));
				} else {

				}
				adjustSame();
			}
		}

	}

	public void deleteColumn() {
		int idx = fViewer.getLastSelectedColumn();
		if (idx >= 0) {
			if (MessageDialog.openQuestion(shell, "Delete Column",
					"Delete column at [" + (idx + 1) + "]["
							+ fCSVRecordDataHolder.getKey()[idx] + "] ?")) {
				fCSVRecordDataHolder.deleteColumn(idx);
				adjustSame();
			}
		}
	}

	public void deleteColumns(Set<String> columnNameSet) {

		for (String targetName : columnNameSet) {
			String[] keys = fCSVRecordDataHolder.getKey();
			for (int i = 0; i < keys.length; i++) {
				if (keys[i].equals(targetName)) {
					fCSVRecordDataHolder.deleteColumn(i);
					break;
				}
			}
		}
		adjustSame();
	}

	public void addColumn() {
		int idx = fViewer.getLastSelectedColumn();
		if (idx >= 0) {
			String desc = "Add column at [" + (idx + 1) + "]["
					+ fCSVRecordDataHolder.getKey()[idx] + "]";
			InsertDialog dialog = new InsertDialog(shell, "addColumn"
					+ fCSVRecordDataHolder.getKey().length, desc, true);
			if (dialog.open() == Dialog.OK) {
				if (dialog.empty) {
					fCSVRecordDataHolder.insertColumn(dialog.before ? idx
							: idx + 1, dialog.title,
							StringUtil.EMPTY_STRING_ARRAY);
				} else {

				}
				adjustSame();
			}
		}
	}

	private static class InsertDialog extends Dialog {
		Button btEmpty;
		boolean empty = true;;
		Combo cmbScripts;
		String title;
		String description;
		Text scriptText, headerText;
		boolean addColumn;
		boolean before;

		public InsertDialog(Shell parent, String initialTitle,
				String description, boolean addColumn) {
			super(parent);
			this.addColumn = addColumn;
			this.description = description;
			title = initialTitle;
		}

		protected Control createDialogArea(Composite parent) {
			FormToolkit toolkit = new FormToolkit(parent.getDisplay());
			ScrolledForm root = toolkit.createScrolledForm(parent);

			root.setText(addColumn ? "Add Column options" : "Add Row options");
			root.setLayout(new GridLayout());
			root.setLayoutData(new GridData(GridData.FILL_BOTH));
			root.getBody().setLayout(new GridLayout());
			root.getBody().setLayoutData(new GridData(GridData.FILL_BOTH));

			Section section = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR | Section.DESCRIPTION);
			section.setText("hoge");
			section.setDescription(description);

			Composite inner = toolkit.createComposite(section);
			GridLayout layout = new GridLayout();
			inner.setLayout(layout);
			layout.numColumns = 2;

			toolkit.createLabel(inner, "Add Position:");
			Composite btnPannel = toolkit.createComposite(inner);
			btnPannel.setLayout(new FillLayout(SWT.HORIZONTAL));
			final Button btBefore = toolkit.createButton(btnPannel, "Before",
					SWT.RADIO);
			final Button btAfter = toolkit.createButton(btnPannel, "After",
					SWT.RADIO);
			btBefore.setSelection(before);
			btAfter.setSelection(!before);
			btBefore.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					before = btBefore.getSelection();
				}
			});
			if (addColumn) {
				toolkit.createLabel(inner, "Header Title:");
				headerText = toolkit.createText(inner, title, SWT.SINGLE);
			}

			toolkit.createLabel(inner, "Empty:");
			btEmpty = toolkit.createButton(inner, StringUtil.EMPTY_STRING,
					SWT.CHECK);
			btEmpty.setSelection(empty);

			Label lb = toolkit.createLabel(inner, "Java scirpt:");
			cmbScripts = new Combo(inner, SWT.READ_ONLY);
			cmbScripts.setEnabled(false);
			btEmpty.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					empty = btEmpty.getSelection();
					cmbScripts.setEnabled(!empty);
					scriptText.setEditable(!empty);
				}
			});
			toolkit.createLabel(inner, "Scirpt texts:");
			scriptText = toolkit.createText(inner, StringUtil.EMPTY_STRING,
					SWT.MULTI);
			scriptText.setEnabled(false);
			scriptText.setLayoutData(new GridData(GridData.FILL_BOTH));

			section.setClient(inner);
			section.setLayoutData(new GridData(GridData.FILL_BOTH));

			// --------------------------------------------------------------------

			// --------------------------------------------------------------------

			return root;
		}

		@Override
		protected void okPressed() {
			if (addColumn) {
				title = headerText.getText();
			}
			super.okPressed();
		}
	}

	public void setNotNullColumns(String[] columnNames) {
		fCSVRecordDataHolder.clearNotNullIdx();
		for (String columnName : columnNames) {
			System.out.println("notNull:" + columnName);
			fCSVRecordDataHolder.addNotNullIdx(columnName);
		}
		fViewer.refresh();
	}

}
