package hiro.yoshioka.sdh.diff;

public enum DiffElementType {
	ADDITION(1), CHANGE(3),

	CONFLICTING(12),

	DELETION(2),

	LEFT(4),

	NO_CHANGE(0),

	PSEUDO_CONFLICT(16),

	RIGHT(8);

	private int code;

	private DiffElementType(int code) {
		this.code = code;
	}

	public int getCode() {
		return code;
	}

	public boolean isChange() {
		return CHANGE.equals(this);
	}

	public boolean isAddition() {
		return ADDITION.equals(this);
	}

	public boolean isDeletion() {
		return DELETION.equals(this);
	}

	public boolean isNoChange() {
		return NO_CHANGE.equals(this);
	}
}