package hiro.yoshioka.sql.resource;

import hiro.yoshioka.util.StringUtil;

public class DBTrigger extends DBResource implements IDBTrigger {
	private static final long serialVersionUID = 9999254846456L;
	protected String fText;

	public DBTrigger(IDBSchema schema) {
		super(schema);
	}

	public void setComment(String remarks) {
		this.comment = remarks;
	}

	public boolean hasText() {
		if (fText == null || fText.length() == 0) {
			return false;
		}
		return true;
	}

	public String getText() {
		return fText;
	}

	/**
	 * @param text
	 *            The fText to set.
	 */
	public void setText(String text) {
		fText = StringUtil.nvl(text).replaceAll("(TRIGGER)\\s+\"(\\w+)\"[.]\"(\\w+)\"", "$1 $2.$3");
	}

	public boolean contain(String pattern) {
		return containKeyInNameOrComment(pattern);
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append(getName());
		if (getComment().length() > 0) {
			buf.append(" y" + getComment() + "z");
		}
		return buf.toString();
	}
}