package hiro.yoshioka.ast.sql.util;

import hiro.yoshioka.ast.sql.oracle.util.WolfParserFactory;
import hiro.yoshioka.sql.resource.DBRoot;

import java.io.File;

public abstract class ParserFactory {

	public static ParserFactory createFactory(String driverName) {
		return new WolfParserFactory();
	}

	public abstract ParserUtil createParserUtil(String statement);

	public abstract ParserUtil createParserUtil(File file);

	public abstract ProposalableParserUtil createParserUtil(String statement,
			DBRoot root);

	public abstract ProposalableParserUtil createParserUtil(File file,
			DBRoot root);

	//--------------------------------------------------------------------------

}
