package hiro.yoshioka.ast.sql.oracle.util;

import hiro.yoshioka.ast.sql.AbsSQLParser;
import hiro.yoshioka.ast.sql.AbsSimpleNode;
import hiro.yoshioka.ast.sql.IDML;
import hiro.yoshioka.ast.sql.oracle.ASTInsertStatement;
import hiro.yoshioka.ast.sql.oracle.ASTUpdateStatement;
import hiro.yoshioka.ast.sql.oracle.WolfSQLParser;
import hiro.yoshioka.ast.sql.oracle.SimpleNode;
import hiro.yoshioka.ast.sql.util.BindInfo;
import hiro.yoshioka.ast.sql.util.ParserUtil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.StringReader;

public class WolfParserUtil extends ParserUtil {

	public WolfParserUtil(File file) throws FileNotFoundException {
		super(file);
	}

	public WolfParserUtil(String string) {
		super(string);
	}

	public AbsSQLParser createParser(StringReader reader) {
		return new WolfSQLParser(reader);
	}

	public AbsSQLParser createParser(FileInputStream stream) {
		return new WolfSQLParser(stream);
	}

	public String getWhereStatement() {
		return null;
	}

//	public String cnvEmptyBlob(BindInfo[] binds) {
//		if (!fParser.nodeCreated()) {
//			return null;
//		}
//
//		if (isDML()) {
//			IDML dml = getDML();
//
//			if (dml instanceof ASTUpdateStatement) {
//				ASTUpdateStatement upd = (ASTUpdateStatement) dml;
//			} else if (dml instanceof ASTInsertStatement) {
//				ASTInsertStatement ins = (ASTInsertStatement) dml;
//			}
//		}
//		return (BindInfo[]) visitor.v.toArray(new BindInfo[0]);
//	}

	public BindInfo[] binds() {
		if (!fParser.nodeCreated()) {
			return null;
		}

		BindCheckSQLNodeVisitor visitor = new BindCheckSQLNodeVisitor(
				getFirstTable());
		visitor.visit((SimpleNode) getSimpleNode(), null);
		return (BindInfo[]) visitor.v.toArray(new BindInfo[0]);
	}

	@Override
	public AbsSimpleNode[] getFoldingNodes() {
		if (!fParser.nodeCreated()) {
			return null;
		}
		FoldingSQLNodeVisitor visitor = new FoldingSQLNodeVisitor();
		visitor.visit((SimpleNode) getSimpleNode(), null);
		return (AbsSimpleNode[]) visitor.v.toArray(new AbsSimpleNode[0]);
	}

}
