package hiro.yoshioka.ast.sql;

import hiro.yoshioka.util.StringUtil;

public class NodeInfomation {
	public IParserException exception;
	public String message;

	public NodeInfomation(IParserException e) {
		exception = e;
	}

	public NodeInfomation(String message) {
		this.message = message;
	}

	public String getLineMessage() {
		if (exception != null) {
			return exception.getMessage();
		} else {
			return StringUtil.nvl(message);
		}
	}

	public boolean hasError() {
		if (exception != null) {
			return true;
		}
		return !StringUtil.isEmpty(message);
	}
}
