/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.complex;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.CursorBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.IndexCursor;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.PageChannel;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.complex.AttachmentColumnInfo;
import com.healthmarketscience.jackcess.complex.ComplexDataType;
import com.healthmarketscience.jackcess.complex.ComplexValue;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.complex.MultiValueColumnInfo;
import com.healthmarketscience.jackcess.complex.UnsupportedColumnInfo;
import com.healthmarketscience.jackcess.complex.VersionHistoryColumnInfo;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComplexColumnInfo<V extends ComplexValue> {
    private static final Log LOG = LogFactory.getLog(Column.class);
    public static final int INVALID_ID = -1;
    public static final ComplexValueForeignKey INVALID_COMPLEX_VALUE_ID = new ComplexValueForeignKey(null, -1);
    private static final String COL_COMPLEX_TYPE_OBJECT_ID = "ComplexTypeObjectID";
    private static final String COL_TABLE_ID = "ConceptualTableID";
    private static final String COL_FLAT_TABLE_ID = "FlatTableID";
    private final Column _column;
    private final int _complexTypeId;
    private final Table _flatTable;
    private final List<Column> _typeCols;
    private final Column _pkCol;
    private final Column _complexValFkCol;
    private IndexCursor _pkCursor;
    private IndexCursor _complexValIdCursor;

    protected ComplexColumnInfo(Column column, int complexTypeId, Table typeObjTable, Table flatTable) throws IOException {
        this._column = column;
        this._complexTypeId = complexTypeId;
        this._flatTable = flatTable;
        ArrayList<Column> typeCols = new ArrayList<Column>();
        ArrayList<Column> otherCols = new ArrayList<Column>();
        ComplexColumnInfo.diffFlatColumns(typeObjTable, flatTable, typeCols, otherCols);
        this._typeCols = Collections.unmodifiableList(typeCols);
        Column pkCol = null;
        Column complexValFkCol = null;
        for (Column col : otherCols) {
            if (col.isAutoNumber()) {
                pkCol = col;
                continue;
            }
            if (col.getType() != DataType.LONG) continue;
            complexValFkCol = col;
        }
        if (pkCol == null || complexValFkCol == null) {
            throw new IOException("Could not find expected columns in flat table " + flatTable.getName() + " for complex column with id " + complexTypeId);
        }
        this._pkCol = pkCol;
        this._complexValFkCol = complexValFkCol;
    }

    public static ComplexColumnInfo<? extends ComplexValue> create(Column column, ByteBuffer buffer, int offset) throws IOException {
        int complexTypeId = buffer.getInt(offset + column.getFormat().OFFSET_COLUMN_COMPLEX_ID);
        Database db = column.getDatabase();
        Table complexColumns = db.getSystemComplexColumns();
        IndexCursor cursor = IndexCursor.createCursor(complexColumns, complexColumns.getPrimaryKeyIndex());
        if (!cursor.findFirstRowByEntry(complexTypeId)) {
            throw new IOException("Could not find complex column info for complex column with id " + complexTypeId);
        }
        Map<String, Object> cColRow = cursor.getCurrentRow();
        int tableId = (Integer)cColRow.get(COL_TABLE_ID);
        if (tableId != column.getTable().getTableDefPageNumber()) {
            throw new IOException("Found complex column for table " + tableId + " but expected table " + column.getTable().getTableDefPageNumber());
        }
        int flatTableId = (Integer)cColRow.get(COL_FLAT_TABLE_ID);
        int typeObjId = (Integer)cColRow.get(COL_COMPLEX_TYPE_OBJECT_ID);
        Table typeObjTable = db.getTable(typeObjId);
        Table flatTable = db.getTable(flatTableId);
        if (typeObjTable == null || flatTable == null) {
            throw new IOException("Could not find supporting tables (" + typeObjId + ", " + flatTableId + ") for complex column with id " + complexTypeId);
        }
        if (MultiValueColumnInfo.isMultiValueColumn(typeObjTable)) {
            return new MultiValueColumnInfo(column, complexTypeId, typeObjTable, flatTable);
        }
        if (AttachmentColumnInfo.isAttachmentColumn(typeObjTable)) {
            return new AttachmentColumnInfo(column, complexTypeId, typeObjTable, flatTable);
        }
        if (VersionHistoryColumnInfo.isVersionHistoryColumn(typeObjTable)) {
            return new VersionHistoryColumnInfo(column, complexTypeId, typeObjTable, flatTable);
        }
        LOG.warn((Object)("Unsupported complex column type " + typeObjTable.getName()));
        return new UnsupportedColumnInfo(column, complexTypeId, typeObjTable, flatTable);
    }

    public void postTableLoadInit() throws IOException {
    }

    public Column getColumn() {
        return this._column;
    }

    public Database getDatabase() {
        return this.getColumn().getDatabase();
    }

    public JetFormat getFormat() {
        return this.getDatabase().getFormat();
    }

    public PageChannel getPageChannel() {
        return this.getDatabase().getPageChannel();
    }

    public Column getPrimaryKeyColumn() {
        return this._pkCol;
    }

    public Column getComplexValueForeignKeyColumn() {
        return this._complexValFkCol;
    }

    protected List<Column> getTypeColumns() {
        return this._typeCols;
    }

    public int countValues(int complexValueFk) throws IOException {
        return this.getRawValues(complexValueFk, Collections.singleton(this._complexValFkCol.getName())).size();
    }

    public List<Map<String, Object>> getRawValues(int complexValueFk) throws IOException {
        return this.getRawValues(complexValueFk, null);
    }

    private Iterator<Map<String, Object>> getComplexValFkIter(int complexValueFk, Collection<String> columnNames) throws IOException {
        if (this._complexValIdCursor == null) {
            this._complexValIdCursor = new CursorBuilder(this._flatTable).setIndexByColumns(this._complexValFkCol).toIndexCursor();
        }
        return this._complexValIdCursor.entryIterator(columnNames, complexValueFk);
    }

    public List<Map<String, Object>> getRawValues(int complexValueFk, Collection<String> columnNames) throws IOException {
        Iterator<Map<String, Object>> entryIter = this.getComplexValFkIter(complexValueFk, columnNames);
        if (!entryIter.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
        while (entryIter.hasNext()) {
            values.add(entryIter.next());
        }
        return values;
    }

    public List<V> getValues(ComplexValueForeignKey complexValueFk) throws IOException {
        List<Map<String, Object>> rawValues = this.getRawValues(complexValueFk.get());
        if (rawValues.isEmpty()) {
            return Collections.emptyList();
        }
        return this.toValues(complexValueFk, rawValues);
    }

    protected List<V> toValues(ComplexValueForeignKey complexValueFk, List<Map<String, Object>> rawValues) throws IOException {
        ArrayList<V> values = new ArrayList<V>();
        for (Map<String, Object> rawValue : rawValues) {
            values.add(this.toValue(complexValueFk, rawValue));
        }
        return values;
    }

    public int addRawValue(Map<String, Object> rawValue) throws IOException {
        Object[] row = this._flatTable.asRow(rawValue);
        this._flatTable.addRow(row);
        return (Integer)this._pkCol.getRowValue(row);
    }

    public int addValue(V value) throws IOException {
        Object[] row = this.asRow(this.newRowArray(), value);
        this._flatTable.addRow(row);
        int id = (Integer)this._pkCol.getRowValue(row);
        value.setId(id);
        return id;
    }

    public void addValues(Collection<? extends V> values) throws IOException {
        for (ComplexValue value : values) {
            this.addValue(value);
        }
    }

    public int updateRawValue(Map<String, Object> rawValue) throws IOException {
        Integer id = (Integer)this._pkCol.getRowValue(rawValue);
        this.updateRow(id, this._flatTable.asUpdateRow(rawValue));
        return id;
    }

    public int updateValue(V value) throws IOException {
        int id = value.getId();
        this.updateRow(id, this.asRow(this.newRowArray(), value));
        return id;
    }

    public void updateValues(Collection<? extends V> values) throws IOException {
        for (ComplexValue value : values) {
            this.updateValue(value);
        }
    }

    public void deleteRawValue(Map<String, Object> rawValue) throws IOException {
        this.deleteRow((Integer)this._pkCol.getRowValue(rawValue));
    }

    public void deleteValue(V value) throws IOException {
        this.deleteRow(value.getId());
    }

    public void deleteValues(Collection<? extends V> values) throws IOException {
        for (ComplexValue value : values) {
            this.deleteValue(value);
        }
    }

    public void deleteAllValues(int complexValueFk) throws IOException {
        Iterator<Map<String, Object>> entryIter = this.getComplexValFkIter(complexValueFk, Collections.<String>emptySet());
        try {
            while (entryIter.hasNext()) {
                entryIter.next();
                entryIter.remove();
            }
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public void deleteAllValues(ComplexValueForeignKey complexValueFk) throws IOException {
        this.deleteAllValues(complexValueFk.get());
    }

    private void moveToRow(Integer id) throws IOException {
        if (this._pkCursor == null) {
            this._pkCursor = new CursorBuilder(this._flatTable).setIndexByColumns(this._pkCol).toIndexCursor();
        }
        if (!this._pkCursor.findFirstRowByEntry(id)) {
            throw new IllegalArgumentException("Row with id " + id + " does not exist");
        }
    }

    private void updateRow(Integer id, Object[] row) throws IOException {
        this.moveToRow(id);
        this._pkCursor.updateCurrentRow(row);
    }

    private void deleteRow(Integer id) throws IOException {
        this.moveToRow(id);
        this._pkCursor.deleteCurrentRow();
    }

    protected Object[] asRow(Object[] row, V value) {
        int id = value.getId();
        this._pkCol.setRowValue(row, id != -1 ? Integer.valueOf(id) : Column.AUTO_NUMBER);
        int cId = value.getComplexValueForeignKey().get();
        this._complexValFkCol.setRowValue(row, cId != -1 ? Integer.valueOf(cId) : Column.AUTO_NUMBER);
        return row;
    }

    private Object[] newRowArray() {
        return new Object[this._flatTable.getColumnCount()];
    }

    public String toString() {
        StringBuilder rtn = new StringBuilder();
        rtn.append("\n\t\tComplexType: " + (Object)((Object)this.getType()));
        rtn.append("\n\t\tComplexTypeId: " + this._complexTypeId);
        return rtn.toString();
    }

    protected static void diffFlatColumns(Table typeObjTable, Table flatTable, List<Column> typeCols, List<Column> otherCols) {
        for (Column col : flatTable.getColumns()) {
            boolean found = false;
            try {
                typeObjTable.getColumn(col.getName());
                found = true;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (found) {
                typeCols.add(col);
                continue;
            }
            otherCols.add(col);
        }
    }

    public abstract ComplexDataType getType();

    protected abstract V toValue(ComplexValueForeignKey var1, Map<String, Object> var2) throws IOException;

    protected static abstract class ComplexValueImpl
    implements ComplexValue {
        private int _id;
        private ComplexValueForeignKey _complexValueFk;

        protected ComplexValueImpl(int id, ComplexValueForeignKey complexValueFk) {
            this._id = id;
            this._complexValueFk = complexValueFk;
        }

        public int getId() {
            return this._id;
        }

        public void setId(int id) {
            if (this._id != -1) {
                throw new IllegalStateException("id may not be reset");
            }
            this._id = id;
        }

        public ComplexValueForeignKey getComplexValueForeignKey() {
            return this._complexValueFk;
        }

        public void setComplexValueForeignKey(ComplexValueForeignKey complexValueFk) {
            if (this._complexValueFk != INVALID_COMPLEX_VALUE_ID) {
                throw new IllegalStateException("complexValueFk may not be reset");
            }
            this._complexValueFk = complexValueFk;
        }

        public Column getColumn() {
            return this._complexValueFk.getColumn();
        }

        public int hashCode() {
            return this._id * 37 ^ this._complexValueFk.hashCode();
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this._id == ((ComplexValueImpl)o)._id && this._complexValueFk.equals(((ComplexValueImpl)o)._complexValueFk);
        }
    }
}

