/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.arnx.jsonic.util.ConstructorInfo;
import net.arnx.jsonic.util.MethodInfo;
import net.arnx.jsonic.util.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanInfo {
    private static final Map<ClassLoader, Map<Class<?>, BeanInfo>> cache = new WeakHashMap();
    private Class<?> type;
    private ConstructorInfo ci;
    private Map<String, PropertyInfo> props = new LinkedHashMap<String, PropertyInfo>();
    private Map<String, MethodInfo> methods = new LinkedHashMap<String, MethodInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanInfo get(Class<?> cls) {
        BeanInfo info = null;
        Map<ClassLoader, Map<Class<?>, BeanInfo>> map = cache;
        synchronized (map) {
            LinkedHashMap map2 = cache.get(cls.getClassLoader());
            if (map2 == null) {
                map2 = new LinkedHashMap<Class<?>, BeanInfo>(16, 0.75f, true){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<Class<?>, BeanInfo> eldest) {
                        return this.size() > 1024;
                    }
                };
                cache.put(cls.getClassLoader(), map2);
            } else {
                info = map2.get(cls);
            }
            if (info == null) {
                info = new BeanInfo(cls);
                map2.put(cls, info);
            }
        }
        return info;
    }

    public static void clear() {
        cache.clear();
    }

    private BeanInfo(Class<?> cls) {
        this.type = cls;
        for (Constructor<?> constructor : cls.getConstructors()) {
            if (constructor.isSynthetic()) continue;
            if (this.ci == null) {
                this.ci = new ConstructorInfo(cls, null);
            }
            constructor.setAccessible(true);
            this.ci.constructors.add(constructor);
        }
        for (AccessibleObject accessibleObject : cls.getFields()) {
            if (((Field)accessibleObject).isSynthetic()) continue;
            boolean isStatic = Modifier.isStatic(((Field)accessibleObject).getModifiers());
            String name = ((Field)accessibleObject).getName();
            ((Field)accessibleObject).setAccessible(true);
            this.props.put(name, new PropertyInfo(cls, name, (Field)accessibleObject, null, null, isStatic));
        }
        for (AccessibleObject accessibleObject : cls.getMethods()) {
            PropertyInfo prop;
            if (((Method)accessibleObject).isSynthetic() || ((Method)accessibleObject).isBridge()) continue;
            String name = ((Method)accessibleObject).getName();
            Class<?>[] paramTypes = ((Method)accessibleObject).getParameterTypes();
            Class<?> returnType = ((Method)accessibleObject).getReturnType();
            boolean isStatic = Modifier.isStatic(((Method)accessibleObject).getModifiers());
            MethodInfo mi = this.methods.get(name);
            if (mi == null) {
                mi = new MethodInfo(cls, name, null, isStatic);
                this.methods.put(name, mi);
            }
            ((Method)accessibleObject).setAccessible(true);
            mi.methods.add((Method)accessibleObject);
            int type = -1;
            if (name.startsWith("get") && name.length() > 3 && !Character.isLowerCase(name.charAt(3)) && paramTypes.length == 0 && !returnType.equals(Void.TYPE)) {
                type = 1;
                name = name.substring(3);
            } else if (name.startsWith("is") && name.length() > 2 && !Character.isLowerCase(name.charAt(2)) && paramTypes.length == 0 && !returnType.equals(Void.TYPE)) {
                type = 1;
                name = name.substring(2);
            } else {
                if (!name.startsWith("set") || name.length() <= 3 || Character.isLowerCase(name.charAt(3)) || paramTypes.length != 1 || paramTypes[0].equals(Void.TYPE)) continue;
                type = 2;
                name = name.substring(3);
            }
            if (name.length() < 2 || !Character.isUpperCase(name.charAt(1))) {
                char[] chars = name.toCharArray();
                chars[0] = Character.toLowerCase(chars[0]);
                name = new String(chars);
            }
            if ((prop = this.props.get(name)) == null) {
                prop = new PropertyInfo(cls, name, null, null, null, isStatic);
                this.props.put(name, prop);
            }
            if (type == 1) {
                prop.readMethod = accessibleObject;
                continue;
            }
            prop.writeMethod = accessibleObject;
        }
    }

    public Object newInstance() {
        try {
            Constructor<?> target = this.type.getConstructor(new Class[0]);
            target.setAccessible(true);
            return target.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    public ConstructorInfo getConstructor() {
        return this.ci;
    }

    public PropertyInfo getProperty(String name) {
        return this.props.get(name);
    }

    public MethodInfo getMethod(String name) {
        return this.methods.get(name);
    }

    public Collection<MethodInfo> getMethods() {
        return this.methods.values();
    }

    public Collection<PropertyInfo> getProperties() {
        return this.props.values();
    }

    public int hashCode() {
        return this.type == null ? 0 : this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BeanInfo other = (BeanInfo)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "BeanInfo [properties = " + this.props + ", methods = " + this.methods + "]";
    }

    static int calcurateDistance(Class<?>[] params, Object[] args) {
        int point = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) {
                if (params[i].isPrimitive()) continue;
                point += 5;
                continue;
            }
            if (params[i].equals(args[i].getClass())) {
                point += 10;
                continue;
            }
            if (params[i].isAssignableFrom(args[i].getClass())) {
                point += 8;
                continue;
            }
            if (Boolean.TYPE.equals(args[i].getClass()) || Boolean.class.equals(args[i].getClass())) {
                if (!Boolean.TYPE.equals(params[i]) && !Boolean.class.equals(params[i].getClass())) continue;
                point += 10;
                continue;
            }
            if (Byte.TYPE.equals(args[i].getClass()) || Byte.class.equals(args[i].getClass())) {
                if (!Byte.TYPE.equals(params[i]) && !Short.TYPE.equals(params[i]) && !Character.TYPE.equals(params[i]) && !Integer.TYPE.equals(params[i]) && !Long.TYPE.equals(params[i]) && !Float.TYPE.equals(params[i]) && !Double.TYPE.equals(params[i]) && !Byte.class.equals(params[i]) && !Short.class.equals(params[i]) && !Character.class.equals(params[i]) && !Integer.class.equals(params[i]) && !Long.class.equals(params[i]) && !Float.class.equals(params[i]) && !Double.class.equals(params[i])) continue;
                point += 10;
                continue;
            }
            if (Short.TYPE.equals(args[i].getClass()) || Short.class.equals(args[i].getClass()) || Character.TYPE.equals(args[i].getClass()) || Character.class.equals(args[i].getClass())) {
                if (!Short.TYPE.equals(params[i]) && !Character.TYPE.equals(params[i]) && !Integer.TYPE.equals(params[i]) && !Long.TYPE.equals(params[i]) && !Float.TYPE.equals(params[i]) && !Double.TYPE.equals(params[i]) && !Short.class.equals(params[i]) && !Character.class.equals(params[i]) && !Integer.class.equals(params[i]) && !Long.class.equals(params[i]) && !Float.class.equals(params[i]) && !Double.class.equals(params[i])) continue;
                point += 10;
                continue;
            }
            if (Integer.TYPE.equals(args[i].getClass()) || Integer.class.equals(args[i].getClass())) {
                if (!Integer.TYPE.equals(params[i]) && !Long.TYPE.equals(params[i]) && !Float.TYPE.equals(params[i]) && !Double.TYPE.equals(params[i]) && !Integer.class.equals(params[i]) && !Long.class.equals(params[i]) && !Float.class.equals(params[i]) && !Double.class.equals(params[i])) continue;
                point += 10;
                continue;
            }
            if (Long.TYPE.equals(args[i].getClass()) || Long.class.equals(args[i].getClass())) {
                if (!Long.TYPE.equals(params[i]) && !Float.TYPE.equals(params[i]) && !Double.TYPE.equals(params[i]) && !Long.class.equals(params[i]) && !Float.class.equals(params[i]) && !Double.class.equals(params[i])) continue;
                point += 10;
                continue;
            }
            if (Float.TYPE.equals(args[i].getClass()) || Float.class.equals(args[i].getClass())) {
                if (!Float.TYPE.equals(params[i]) && !Double.TYPE.equals(params[i]) && !Float.class.equals(params[i]) && !Double.class.equals(params[i])) continue;
                point += 10;
                continue;
            }
            if (!Double.TYPE.equals(args[i].getClass()) && !Double.class.equals(args[i].getClass()) || !Double.TYPE.equals(params[i]) && !Double.class.equals(params[i])) continue;
            point += 10;
        }
        return point;
    }
}

