package hiro.yoshioka.util;

import java.io.File;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author admin
 * 
 *         To change the template for this generated type comment go to
 *         Window>Preferences>Java>Code Generation>Code and Comments
 */
public class DirCleaner extends File {
	private static Log log = LogFactory.getLog(DirCleaner.class);

	public DirCleaner(String name) {
		super(name);
	}

	public DirCleaner(File path, String name) {
		super(path, name);
	}

	public DirCleaner(String path, String name) {
		super(path, name);
	}

	public boolean deleteAllDir() {
		if (exists() && isDirectory()) {
			return deleteAllDir(this);
		} else {
			log.fatal("No such Directory[" + getAbsolutePath() + "]");
		}
		return false;
	}

	private boolean deleteAllDir(File file) {
		boolean del = true;
		File[] flist = file.listFiles();
		for (int i = 0; i < flist.length; i++) {
			if (flist[i].isDirectory()) {
				if (!deleteAllDir(flist[i])) {
					del = false;
				}
			}
			if (!flist[i].delete()) {
				del = false;
			}
		}
		return del;
	}
}
