package hiro.yoshioka.sql.resource;

import hiro.yoshioka.util.StringUtil;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.graphics.Image;

public class DBTable extends DBResource implements IDBTable {
	private static final long serialVersionUID = 999962501456L;
	private static IDBColumn[] EMPTY_COLUMN = new IDBColumn[0];

	/** TABLE_TYPE */
	protected String tableType;

	/** PROCEDURE_TYPE */
	protected short _procedureType = -9;

	protected final boolean fDictionary;

	protected boolean fTmpSelection;

	protected boolean fSelectAll;

	protected String fText;

	protected static List fNULLList = new ArrayList();

	public static transient Image image;

	/**
	 * Constructs a new DBTable containing the DBSchema
	 * 
	 * @param schema
	 *            XL[}
	 */
	public DBTable(IDBSchema schema) {
		super(schema);
		fDictionary = false;
	}

	public DBTable(DBDictionaryRoot droot) {
		super(droot);
		fDictionary = true;
	}

	public IDBColumn[] getColumns() {
		List list = listResources();
		return (IDBColumn[]) list.toArray(new IDBColumn[list.size()]);
	}

	public void setTableType(String value) {
		tableType = value;
	}

	public boolean isTable() {
		if (tableType == null) {
			return false;
		}
		return tableType.equals(TABLE_TYPE_TABLE);
	}

	public boolean isView() {
		if (tableType == null) {
			return false;
		}
		return tableType.equals(TABLE_TYPE_VIEW);
	}

	public boolean isSynonym() {
		if (tableType == null) {
			return false;
		}
		return tableType.equals(TABLE_TYPE_SYNONYM);
	}

	public boolean isFunction() {
		if (tableType == null) {
			if (_procedureType == 0 || _procedureType == 2) {
				return true;
			}
		}
		return false;
	}

	public boolean isProcudeure() {
		return _procedureType == 1 && tableType == null;
	}

	public boolean isDictionary() {
		return fDictionary;
	}

	public boolean isSystem() {
		if (tableType == null) {
			return false;
		}
		return tableType.equals(TABLE_TYPE_SYSTEM_TABLE);
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		if (fTmpSelection) {
			buf.append("yTMP:" + _children.size() + "z");
		}
		buf.append(getName());
		if (getComment().length() > 0) {
			buf.append(" y" + getComment() + "z");
		}

		return buf.toString();
	}

	public void setComment(String remarks) {
		this.comment = remarks;
	}

	@Override
	public void slimUp() {

	}

	public void setProcedureType(short procedureType) {
		_procedureType = procedureType;
	}

	public boolean contain(String pattern) {
		if (containKeyInNameOrComment(pattern)) {
			return true;
		}
		if (listResources(pattern).size() > 0) {
			return true;
		}
		return false;
	}

	// String getIndexNames(IDBColumn column) {
	// if (!hasIndex()) {
	// return "";
	// }
	// StringBuffer buf = new StringBuffer();
	// for (Iterator ite = fIndexList.iterator(); ite.hasNext();) {
	// DBIndex element = (DBIndex) ite.next();
	// if (element.contain(column.getName(), IDB_COLUMN)) {
	// buf.append(element.getName()).append(", ");
	// }
	// }
	// if (buf.length() > 2) {
	// buf.setLength(buf.length() - 2);
	// }
	// return buf.toString();
	// }
	//
	// public boolean hasIndex(IDBColumn column) {
	// for (Iterator ite = fIndexList.iterator(); ite.hasNext();) {
	// DBIndex element = (DBIndex) ite.next();
	// if (element.contain(column.getName(), 0)) {
	// return true;
	// }
	// }
	// return false;
	// }

	/*
	 * (non-Javadoc)
	 * 
	 * @see hiro.yoshioka.sql.resource.IDBTable#setSelectAll()
	 */
	public void setSelectAll() {
		fSelectAll = true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see hiro.yoshioka.sql.resource.IDBTable#getSelectAll()
	 */
	public boolean getSelectAll() {
		// TODO Auto-generated method stub
		return fSelectAll;
	}

	public boolean hasText() {
		if (fText == null || fText.length() == 0) {
			return false;
		}
		return true;
	}

	public boolean hasPk() {
		List<IDBResource> alllist = listResources();
		for (int i = 0; i < alllist.size(); i++) {
			IDBColumn col = (IDBColumn) alllist.get(i);
			if (col.isPkey()) {
				return true;
			}
		}
		return false;
	}

	public void putResource(String key, IDBResource child) {
		super.putResource(key, child);
	}

	public int[] getPkPositions() {
		List<IDBResource> alllist = listResources();
		List<Integer> retList = new ArrayList<Integer>();
		for (int i = 0; i < alllist.size(); i++) {
			IDBColumn col = (IDBColumn) alllist.get(i);
			if (col.isPkey()) {
				retList.add(new Integer(i));
			}
		}
		int[] retInt = new int[retList.size()];
		for (int i = 0; i < retInt.length; i++) {
			retInt[i] = retList.get(i);
		}
		return retInt;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see hiro.yoshioka.sql.resource.IDBTable#isShadow()
	 */
	public boolean isShadow() {
		return fTmpSelection;
	}

	/**
	 * RecAVXgpIDBColumn ListԋpB
	 * 
	 * @return AVXgpIDBColumn List
	 */
	public List getProposal(IDBSchema another, String schemaString,
			String tableNameString, String columnString) {
		if (schemaString.length() > 0) {// XL[}Ae[u ̓GCAX
			if (tableNameString.length() > 0) {
				if (columnString.length() > 0) { // SĎw
					return startsWithResourceLists(columnString);
				}
				return listResources();
			}
			if (getAlias().equalsIgnoreCase(schemaString)) {// GCAXv
				if (columnString.length() > 0) {
					return startsWithResourceLists(columnString);
				}
				return listResources();
			}
			if (getName().equalsIgnoreCase(schemaString)) {// e[uv
				if (columnString.length() > 0) { // SĎw
					return startsWithResourceLists(columnString);
				}
				return listResources();
			}
			if (another != null && !another.equals(getParent())) {
				List list = new ArrayList();
				if (getParent() != null
						&& getParent().getUName().startsWith(schemaString)) {
					list.add(this);
				}
				return list;
			}
			return fNULLList;
		}
		if (columnString.length() == 0) {
			return listResources();
		}
		return startsWithResourceLists(columnString);
	}

	public boolean hasAlias() {
		return getAlias().length() > 0;
	}

	public String getImageString() {
		if (isProcudeure()) {
			return "\u24c5";
		} else if (isFunction()) {
			return "\u24bb";
		} else if (isView()) {
			return "\u24cb";
		} else if (isSynonym()) {
			return "\u24c8";
		} else {
			return "\u24c9";
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see hiro.yoshioka.sql.resource.IDBTable#getUAlias()
	 */
	public String getUAlias() {
		return getAlias().toUpperCase();
	}

	/**
	 * @return Returns the fText.
	 */
	public String getText() {
		return fText;
	}

	/**
	 * @param text
	 *            The fText to set.
	 */
	public void setText(String text) {
		fText = StringUtil
				.nvl(text)
				.replaceAll(
						"(TABLE|VIEW|SYNONYM|PROCEDURE|FUNCTION)\\s+\"(\\w+)\"[.]\"(\\w+)\"",
						"$1 $2.$3");
	}

	public IDBColumn[] getInputColumns() {
		if (isProcudeure() || isFunction()) {
			ArrayList<IDBColumn> list = new ArrayList<IDBColumn>();
			List<IDBResource> alllist = listResources();
			for (int i = 0; i < alllist.size(); i++) {
				IDBColumn col = (IDBColumn) alllist.get(i);
				if (col.isColumnIn() || col.isColumnInOut()) {
					list.add(col);
				}
			}
			return list.toArray(new IDBColumn[list.size()]);
		}
		return EMPTY_COLUMN;
	}

	public IDBColumn getReturnColumn() {
		if (isProcudeure() || isFunction()) {
			List<IDBResource> alllist = listResources();
			for (int i = 0; i < alllist.size(); i++) {
				IDBColumn col = (IDBColumn) alllist.get(i);
				if (col.isColumnReturn()) {
					return col;
				}
			}
		}
		return null;
	}

	public IDBColumn[] getOutputColumns() {
		if (isProcudeure() || isFunction()) {
			ArrayList<IDBColumn> list = new ArrayList<IDBColumn>();
			List<IDBResource> alllist = listResources();
			for (int i = 0; i < alllist.size(); i++) {
				IDBColumn col = (IDBColumn) alllist.get(i);
				if (col.isColumnOut() || col.isColumnInOut()
						|| col.isColumnReturn()) {
					list.add(col);
				}
			}
			return list.toArray(new IDBColumn[list.size()]);
		}
		return EMPTY_COLUMN;
	}

	public DBCrossRefference[] getCrossReferences() {
		DBIndexRoot root = ((DBRoot) getParent().getParent()).getDBIndexRoot();
		return root.getCrossReferences(this);
	}

	public Image getImage() {
		return image;
	}

	public IDBTable clone() {
		DBTable ret = new DBTable((IDBSchema) getParent());
		ret.setTableType(tableType);
		ret.setProcedureType(_procedureType);
		ret.fTmpSelection = fTmpSelection;
		ret.fSelectAll = fSelectAll;
		ret.fText = fText;
		ret.name = name;
		ret._children = _children;

		return ret;
	}

	public String getAlias() {
		DBRoot root = getRoot();
		if (root == null) {
			return StringUtil.EMPTY_STRING;
		}
		String[] ret = root.getAlias(this);
		if (ret.length == 0) {
			return StringUtil.EMPTY_STRING;
		}
		return ret[0];
	}

	public String[] getAllAlias() {
		DBRoot root = getRoot();
		if (root == null) {
			return StringUtil.EMPTY_STRING_ARRAY;
		}
		return root.getAlias(this);
	}

	public void addAlias(String alias) {
		DBRoot root = getRoot();
		if (root != null) {
			root.addAlias(this, alias);
		}
	}
}