package hiro.yoshioka.ast.sql.oracle.util;

import hiro.yoshioka.ast.sql.RowColumn;
import hiro.yoshioka.ast.sql.oracle.ASTCondition;
import hiro.yoshioka.ast.sql.oracle.SimpleNode;
import hiro.yoshioka.ast.sql.util.ASTAssist;

public class PastCheckSQLNodeVisitor extends DefaultSQLNodeVisitor {
	public int fPointElementType;

	public ASTAssist fAssist;
	public ASTAssist fpAssist;

	public Object doJob(SimpleNode node, Object data) {
		if (node.past((RowColumn) data)) {
			v.add(node);
			if (node.fASTAssist != null) {
				fAssist = node.fASTAssist;
				if (log.isInfoEnabled()) {
					log.info("NODE[" + node + "] past has Assist" + fAssist);
				}
			}
		}

		SimpleNode n;
		for (int ord = 0; ord < node.jjtGetNumChildren(); ord++) {
			n = (SimpleNode) node.jjtGetChild(ord);
			n.jjtAccept(this, data);
		}
		return v;
	}

	public Object visit(ASTCondition node, Object data) {
		if (node.past((RowColumn) data)) {
			v.add(node);
			if (node.fASTAssist != null && fAssist == null) {
				fAssist = node.fASTAssist;
				if (log.isInfoEnabled()) {
					log.info("pNODE[" + node + "] past has Assist"
							+ node.fASTAssist);
				}
			}
		}

		SimpleNode n;
		for (int ord = 0; ord < node.jjtGetNumChildren(); ord++) {
			n = (SimpleNode) node.jjtGetChild(ord);
			n.jjtAccept(this, data);
		}
		return v;
	}

}