package hiro.yoshioka.ast.sql.oracle;

import hiro.yoshioka.ast.sql.ISchemaTableColumn;
import hiro.yoshioka.ast.sql.IToken;

public abstract class ASTDefaultSchemaTableColumn extends SimpleNode implements ISchemaTableColumn {
    public String fSchemaString = "";

    public String fColumnString = "";

    public String fTableNameString = "";

    public IToken fQuestion;

    public IToken fColumnToken;

    public ASTDefaultSchemaTableColumn(int id) {
        super(id);
    }

    public ASTDefaultSchemaTableColumn(WolfSQLParser p, int id) {
        super(p, id);
    }

    public boolean isQuestion() {
        return fQuestion != null;
    }

    public boolean containOnlyColumnString() {
        if (fSchemaString.length() == 0 && fTableNameString.length() == 0 && fColumnString.length() > 0) {
            return true;
        }
        return false;
    }

    public String getUpperTable() {
        return fTableNameString.toUpperCase();
    }

    public String getTableString() {
        return fTableNameString;
    }

    public String getUpperSchema() {
        return fSchemaString.toUpperCase();
    }

    public String getSchemaString() {
        return fSchemaString;
    }

    public String getUpperColumn() {
        return fColumnString.toUpperCase();
    }

    public String getColumnString() {
        return fColumnString;
    }

    public String infomation() {
        StringBuilder buf = new StringBuilder(getClass().getName() + "[");
        if (fSchemaString.length() > 0) {
            buf.append(getUpperSchema()).append(".");
        }
        if (fTableNameString.length() > 0) {
            buf.append(getUpperTable()).append("#");
        }
        buf.append(getUpperColumn());
        buf.append("] hasDot?");
        buf.append(containDot());
        return buf.toString();
    }

    /*
     * (non-Javadoc)
     * 
     * @see hiro.yoshioka.ast.sql.mysql.ISchemaTableColumn#containDot()
     */
    public boolean containDot() {
        if (fSchemaString.length() > 0 || fTableNameString.length() > 0) {
            return true;
        }
        return false;
    }

}
