package hiro.yoshioka.util;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtil {
	private static Log log = LogFactory.getLog(FileUtil.class);

	private Class location;

	private String name;

	public FileUtil(Class clazz, String filename) {
		this.location = clazz;
		this.name = filename;
	}

	public static void main(String[] arg) {
		System.out.println(renameForWindows("aiueo\\/:|", "_"));
	}

	public static String renameForWindows(String name, String replacement) {
		if (name == null) {
			return name;
		}
		return name.replaceAll("[\\\\/:*?\"<>|]", replacement);
	}

	public static boolean existsAndReadableFile(File[] files) {
		for (File f : files) {
			if (!f.isFile() || !f.exists() || !f.canRead()) {
				return false;
			}
		}
		return true;
	}

	public static boolean existsAndReadableFile(String filePath) {
		return existsAndReadableFile(new File[] { new File(filePath) });
	}

	public static boolean existsAndReadableFile(File file) {
		return existsAndReadableFile(new File[] { file });
	}

	public static String[] getTexts(File f, String encode) {
		BufferedReader in = null;

		List<String> retList = new ArrayList<String>();
		try {
			if (StringUtil.isEmpty(encode)) {
				in = new BufferedReader(new FileReader(f));
			} else {
				in = new BufferedReader(new InputStreamReader(
						new FileInputStream(f), encode));
			}
			String line;

			while ((line = in.readLine()) != null) {
				retList.add(line);
			}
			in.close();
		} catch (Exception e) {
			e.printStackTrace();
		}

		return (String[]) retList.toArray(new String[retList.size()]);
	}

	public static String[] getTexts(File f) {
		return getTexts(f, null);
	}

	public static void writeFile(File file, String text, String encode) {
		PrintWriter writer = null;
		try {
			if (StringUtil.isEmpty(encode)) {
				writer = new PrintWriter(new FileWriter(file));
			} else {
				writer = new PrintWriter(new OutputStreamWriter(
						new FileOutputStream(file), encode));
			}
			writer.print(text);
			writer.flush();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (writer != null) {
				writer.close();
			}
		}
	}

	public static String getText(InputStream iStream, String encode) {
		return getText(iStream, encode, -1);
	}

	public static String getText(InputStream iStream, String encode,
			long limitLength) {
		BufferedReader in = null;
		try {
			if (StringUtil.isEmpty(encode)) {
				in = new BufferedReader(new InputStreamReader(iStream));
			} else {
				in = new BufferedReader(new InputStreamReader(iStream, encode));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		return getText(in, encode, limitLength);
	}

	private static String getText(BufferedReader in, String encode,
			long limitLength) {
		StringBuilder buf = new StringBuilder();

		try {
			String line;

			while ((line = in.readLine()) != null) {
				buf.append(line).append(StringUtil.LINE_SEPARATOR);
				if (limitLength > 0 && buf.length() > limitLength) {
					break;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (in != null) {
				try {
					in.close();
				} catch (IOException e) {
				}
			}
		}

		return buf.toString();
	}

	public static String getText(File f, String encode) {
		BufferedReader in = null;
		try {
			if (StringUtil.isEmpty(encode)) {
				in = new BufferedReader(new InputStreamReader(
						new FileInputStream(f)));
			} else {
				in = new BufferedReader(new InputStreamReader(
						new FileInputStream(f), encode));
			}
		} catch (Exception e) {
			e.printStackTrace();
			return StringUtil.EMPTY_STRING;
		}
		return getText(in, encode, -1);
	}

	public static String getText(File f) {
		return getText(f, null);
	}

	public static void deleteEmptyFolder(File dir) {
		if (dir.isDirectory()) {
			File[] children = dir.listFiles();
			if (children.length > 0) {
				for (int i = 0; i < children.length; i++) {
					if (children[i].isFile() && children[i].length() == 0) {
						children[i].delete();
					} else if (children[i].isDirectory()) {
						deleteEmptyFolder(children[i]);
					}
				}
			} else {
				dir.delete();
			}
		}
	}

	public BufferedInputStream getStream() {
		InputStream is = null;

		if (location != null) {
			is = location.getResourceAsStream(name);

		} else {
			try {
				is = new FileInputStream(name);
			} catch (FileNotFoundException e) {
				return null;
			}
		}
		if (is == null) {
			return null;
		} else {
			return new BufferedInputStream(is);
		}
	}

	public static Object readObject(File f) {
		return readObject(f, null);
	}

	public static Object readObject(File f, ClassLoader readingClassLoader) {
		ObjectInputStream in = null;
		try {
			if (f.exists() && f.isFile()) {
				if (readingClassLoader == null) {
					in = new ObjectInputStream(new FileInputStream(f));
					return in.readObject();
				} else {
					ClassLoader oldLoader = Thread.currentThread()
							.getContextClassLoader();
					try {
						Thread.currentThread().setContextClassLoader(
								readingClassLoader);
						in = new ObjectInputStream(new FileInputStream(f));
						return in.readObject();
					} catch (Exception e) {
						log.info("Reading exception ", e);
					} finally {
						Thread.currentThread().setContextClassLoader(oldLoader);
					}
					return null;
				}
			} else {
				log.info("File Not Found or Not File [" + f.getAbsolutePath()
						+ "]");
				return null;
			}
		} catch (Exception e) {
			log.info("Deserialize error", e);
			return null;
		} finally {
			if (in != null) {
				try {
					in.close();
				} catch (IOException e1) {
					return null;
				}
			}
		}
	}

	public static boolean save(File f, Object saveObject) throws IOException {
		ObjectOutputStream out = null;
		try {
			out = new ObjectOutputStream(new FileOutputStream(f));
			out.writeObject(saveObject);
			return true;
		} catch (Exception e) {
			log.error(e);
			return false;
		} finally {
			if (out != null) {
				out.close();
			}
		}
	}

	public static Object readObjectXML(File f) {
		XMLDecoder decoder = null;
		try {
			decoder = new XMLDecoder(new BufferedInputStream(
					new FileInputStream(f)));
			return decoder.readObject();
		} catch (FileNotFoundException e) {
			log.error(e);
		} finally {
			decoder.close();
		}
		return null;
	}

	public static boolean saveXML(File f, ClassLoader savingClassLoader,
			Object saveObject) {
		XMLEncoder encoder = null;
		ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
		try {
			log.info("save file->" + f);
			Thread.currentThread().setContextClassLoader(savingClassLoader);
			encoder = new XMLEncoder(new BufferedOutputStream(
					new FileOutputStream(f)));
			encoder.writeObject(saveObject);
			encoder.close();
			return true;
		} catch (Throwable e) {
			log.error(e);
		} finally {
			Thread.currentThread().setContextClassLoader(oldLoader);
		}
		return false;
	}
}
