package hiro.yoshioka.sql.params;

import hiro.yoshioka.util.StringUtil;

import java.io.File;
import java.io.Serializable;

import sun.swing.StringUIClientPropertyKey;

public class SSHProperties implements Serializable, Cloneable {
	private static final long serialVersionUID = 3141534388803157250L;
	public String definition_name;

	public String hostname = StringUtil.EMPTY_STRING;
	public String username = StringUtil.EMPTY_STRING;
	public String password = StringUtil.EMPTY_STRING;
	//
	// or "~/.ssh/id_dsa"
	public File keyfile;
	// will be ignored if not needed
	public String keyfilePass = StringUtil.EMPTY_STRING;

	// -----------------------------------------------
	// LocalPortForwarder
	// -----------------------------------------------
	public int local_port;
	public String host_to_connect = StringUtil.EMPTY_STRING;
	public int port_to_connect;

	// -----------------------------------------------
	// RemotePortForwarding
	// -----------------------------------------------
	public String bindAddress = StringUtil.EMPTY_STRING;
	public int bindPort;
	public String targetAddress = StringUtil.EMPTY_STRING;
	public int targetPort;

	public SSHProperties() {
	}

	public SSHProperties(String definition_name, String host_name) {
		this.definition_name = definition_name;
		this.hostname = host_name;
	}

	@Override
	public Object clone() throws CloneNotSupportedException {
		return super.clone();
	}

	public void setAuthenticateWithPassword(String user, String password) {
		this.username = user;
		this.password = password;
	}

	public void createRemotePortForwarding(String bindAddress, int bindPort,
			String targetAddress, int targetPort) {
		this.bindAddress = bindAddress;
		this.bindPort = bindPort;
		this.targetAddress = targetAddress;
		this.targetPort = targetPort;
	}

	public void createLocalPortForwarder(int local_port,
			String host_to_connect, int port_to_connect) {
		this.local_port = local_port;
		this.host_to_connect = host_to_connect;
		this.port_to_connect = port_to_connect;
	}

	public String getDefinition_name() {
		return definition_name;
	}

	public String getShortInformation() {
		StringBuilder buf = new StringBuilder();
		buf.append(String.format("SSH-Authenticate[%s/%s]", hostname, username));

		return buf.toString();
	}

	@Override
	public String toString() {
		StringBuilder buf = new StringBuilder();
		buf.append(String.format("SSH-Authenticate[%s/%s]%n", hostname,
				username));
		buf.append(String.format("SSH-LocalportForwarder[%d/%s:%d]%n",
				local_port, host_to_connect, port_to_connect));
		buf.append(String.format("SSH-RemoteportForwarder[%s:%d/%s:%d]%n",
				bindAddress, bindPort, targetAddress, targetPort));

		return buf.toString();
	}
}
