package hiro.yoshioka.sql;

import hiro.yoshioka.sdh.ResultSetMetaCopy;
import hiro.yoshioka.sdh2.ReflectionPreparedStatement;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.engine.MirroringRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBCrossRefference;
import hiro.yoshioka.sql.resource.DBResourceType;
import hiro.yoshioka.sql.resource.IDBSequence;
import hiro.yoshioka.sql.resource.IDBTable;

import java.sql.ResultSet;
import java.sql.SQLException;

import jp.sf.orangesignal.csv.CsvWriter;
import jp.sf.orangesignal.csv.handlers.ResultSetHandler;

public interface ITransactionSQL extends IAbsBasicSQL {

	ResultSet getAllData(IDBTable table) throws SQLException;

	ResultSetDataHolder2 getAllData2(IDBTable table, Request request)
			throws SQLException;

	ResultSetDataHolder2 getAllData2(String schema, String table,
			Request request) throws SQLException;

	int count(String sql_statement) throws SQLException;

	ResultSetDataHolder2 counts(String[] sql_statements) throws SQLException;

	boolean execute(ReflectionPreparedStatement ref) throws SQLException;

	boolean execute(String sql_statement) throws SQLException;

	void executePrepareQueryByLine(String sql_statement, LineListener listner)
			throws SQLException;

	boolean execute(String sql_statement, String[] args) throws SQLException;

	ResultSetDataHolder2 executePrepare(String sql_statement, Object[] arg1)
			throws SQLException;

	ResultSetDataHolder2 executePrepareQuery(String sql_statement,
			Object[] binds) throws SQLException;

	void setMaxRowNum(int max);

	boolean saveCsv(String sql_statement, ResultSetHandler handler,
			CsvWriter writer) throws SQLException;

	// --------------------------------------------------------------------------
	// --
	/**
	 * Cancels this Statement object if both the DBMS and driver support
	 * aborting an SQL statement. <BR>
	 * This method can be used by one thread to cancel a statement that is being
	 * executed by another thread
	 */
	// --------------------------------------------------------------------------
	// --
	boolean cansel() throws SQLException;

	boolean commit();

	boolean rollback();

	boolean trunsactionTime();

	/***
	 * 
	 * @return TRUE:o.k. FALSE n.g. NULL: unknown or not support yet.
	 */
	Boolean isAlive(ConnectionProperties properties) throws SQLException;

	ResultSetMetaCopy getTableMetaCopy(String name);

	ResultSetMetaCopy getTableMetaCopy(String name, String[] strings);

	// ----------------------------------------------------------------
	// [4] DIFF
	// ----------------------------------------------------------------
	ResultSetDataHolder2 getDiffInfoOf(DBResourceType resourceType,
			String schemaName, boolean withValue);

	// ----------------------------------------------------------------
	// [5] MIRRORING
	// ----------------------------------------------------------------
	boolean createMirroredTableTo(MirroringRequest mirroring_request)
			throws SQLException;

	boolean createMirroredTableTo_FaseOnSchema(
			MirroringRequest mirroring_request) throws SQLException;

	boolean createMirroredTableTo_FaseOnTable(MirroringRequest mirroring_request)
			throws SQLException;

	boolean migration(ITransactionSQL osql, DBCrossRefference original,
			boolean drop, boolean cascade) throws SQLException;

	boolean migration(ITransactionSQL osql, IDBSequence original, boolean drop,
			boolean cascade, boolean noSchema) throws SQLException;

	void updateLatestRequestTime();

}