package hiro.yoshioka.sql.resource.evernote;

import hiro.yoshioka.sql.resource.DBColumn;
import hiro.yoshioka.sql.resource.IDBTable;

import java.io.Serializable;

public class EvernoteDBColumn extends DBColumn implements Serializable {
	private static final long serialVersionUID = -3336567252876609801L;
	private EvernoteColumnType columnType;

	public EvernoteDBColumn(IDBTable table, EvernoteColumnType columnType) {
		super(table);
		this.columnType = columnType;
	}

	public EvernoteColumnType getEvernoteColumnType() {
		return columnType;
	}

	@Override
	public String getDefaultConditionValue() {
		EvernoteDBTable table = (EvernoteDBTable) getParent();
		EvernoteDBSchema schema = (EvernoteDBSchema) table.getParent();
		switch (this.columnType) {
		case notebookGuid:
			return table.getGuid();
		}
		return columnType.getDefaultValue(getRoot(), schema.getSchemaType(),
				table.getEvernoteTableType());
	}
}