package hiro.yoshioka.sql.resource.access;

import hiro.yoshioka.sql.resource.DBColumn;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.util.SQLDataType;

import java.io.Serializable;
import java.sql.SQLException;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataType;

public class AccessDBColumn extends DBColumn implements Serializable {
	private static final long serialVersionUID = 4244110084926704020L;

	public AccessDBColumn(IDBTable table, Column col) {
		super(table);
		setName(col.getName());
		setSize(col.getLength());
		setDataTypeString(col.getType().name());
		try {
			switch (col.getType()) {
			case GUID:
				setDataType(SQLDataType.VARCHAR);
				break;
			case MEMO:
				setSize(4056);
				setDataType(SQLDataType.parse(col.getType().getSQLType()));
				break;
			default:
				setDataType(SQLDataType.parse(col.getType().getSQLType()));
				break;
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}
}
