package hiro.yoshioka.sql.resource.xml;

import hiro.yoshioka.sql.resource.IDBResource;
import hiro.yoshioka.sql.resource.INameFamily;
import hiro.yoshioka.util.StringUtil;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class DBResouceValue implements INameFamily {
	DBResouceValue parent;

	String name;

	String comment;

	protected String alias = StringUtil.EMPTY_STRING;

	Properties propeties;

	protected Map<String, DBResouceValue> children = new LinkedHashMap<String, DBResouceValue>();

	public DBResouceValue() {
	}

	public DBResouceValue(IDBResource resource) {
		name = resource.getName();
		comment = resource.getComment();
		this.alias = resource.getAlias();
		this.propeties = resource.getProperties();
	}

	public Map<String, DBResouceValue> getChildren() {
		return children;
	}

	public void setChildren(Map<String, DBResouceValue> children) {
		this.children = children;
	}

	public String getComment() {
		return comment == null ? "" : comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public String getName() {
		return name == null ? "" : name;
	}

	public String getNameWithComment(int size) {
		String retVal;
		if (getComment().length() > 0) {
			retVal = getName() + " \"" + getComment() + "\"";
		} else {
			retVal = getName();
		}
		if (size <= 0) {
			return retVal;
		}
		if (retVal.length() > size) {
			return retVal.substring(0, size) + "..\"";
		}
		return retVal;
	}

	public String getNameWithComment() {
		if (getComment().length() > 0) {
			return getName() + " \"" + getComment() + "\"";
		}
		return getName();
	}

	public String getNameWithAsComment() {
		if (getComment().length() > 0) {
			return getName() + " As \"" + getComment() + "\"";
		}
		return getName();
	}

	public String getUName() {
		return getName().toUpperCase();
	}

	public void setName(String name) {
		this.name = name;
	}

	@Override
	public DBResouceValue getParent() {
		return parent;
	}

	@Override
	public void setParent(INameFamily parent) {
		this.parent = (DBResouceValue) parent;
	}

	public void setParent(DBResouceValue parent) {
		this.parent = parent;
	}

	@Override
	public void setAlias(String alias) {
		this.alias = alias;
	}

	@Override
	public boolean hasAlias() {
		return !StringUtil.isEmpty(this.alias);
	}

	@Override
	public void clearAlias() {
		this.alias = StringUtil.EMPTY_STRING;
	}

	@Override
	public String getAlias() {
		return alias;
	}

	@Override
	public Properties getProperties() {
		return propeties;
	}

	@Override
	public void setProperties(Properties p) {
		this.propeties = p;
	}
}
