package hiro.yoshioka.sql.resource;

import java.util.Set;
import java.util.TreeSet;

public enum DBResourceType {
	DATABASE(5), SCHEMA(10), TABLE(20), VIEW(25), PROCEDURE(30), FUNCTION(35), SYNONYM(
			40), SEQUENCE(50), TRIGGER(60), COLUMN(100);

	private int code;

	public static Set<DBResourceType> COMPARE_SUPPORT_SET = new TreeSet<DBResourceType>();
	static {
		COMPARE_SUPPORT_SET.add(TABLE);
		COMPARE_SUPPORT_SET.add(VIEW);
		COMPARE_SUPPORT_SET.add(FUNCTION);
		// COMPARE_SUPPORT_SET.add(SYNONYM);
		COMPARE_SUPPORT_SET.add(SEQUENCE);
		// COMPARE_SUPPORT_SET.add(TRIGGER);
	}

	private DBResourceType(int code) {
		this.code = code;
	}

	public int getCode() {
		return code;
	}
}
