package hiro.yoshioka.sdh;

public enum ConditionOperatorType {
	Equal("eq", "="), LessThan("lt", "<"), LessEqual("le", "<="), GreatorEqual(
			"ge", ">="), GreatorThan("gt", ">"), Like("like", "LIKE"), IsNull(
			"IS NULL", "IS NULL"), IsNotNull("IS NOT NULL", "IS NOT NULL");

	private String min;
	private String symbol;

	private ConditionOperatorType(String min, String symbol) {
		this.min = min;
		this.symbol = symbol;
	}

	public String getMin() {
		return min;
	}

	public String getSymbol() {
		return symbol;
	}

	public boolean isNull() {
		return IsNull.equals(this);
	}

	public boolean isNotNull() {
		return IsNotNull.equals(this);
	}

	public static String[] getAllMins() {
		ConditionOperatorType[] all = values();
		String[] ret = new String[all.length];
		int i = 0;
		for (ConditionOperatorType c : all) {
			ret[i++] = c.min;
		}
		return ret;
	}

	public static String[] getAllSymbols() {
		ConditionOperatorType[] all = values();
		String[] ret = new String[all.length];
		int i = 0;
		for (ConditionOperatorType c : all) {
			ret[i++] = c.symbol;
		}
		return ret;
	}

	public static ConditionOperatorType parseBySymbol(String symbolStr) {
		for (ConditionOperatorType c : values()) {
			if (c.symbol.equalsIgnoreCase(symbolStr)) {
				return c;
			}
		}
		return null;
	}

	public static ConditionOperatorType parseByMin(String minStr) {
		for (ConditionOperatorType c : values()) {
			if (c.min.equalsIgnoreCase(minStr)) {
				return c;
			}
		}
		return null;
	}
}
