package hiro.yoshioka.eclipse.core;

import java.io.ByteArrayInputStream;
import java.util.Random;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CoreUtil {
	protected static Log fLogger = LogFactory.getLog(CoreUtil.class.getClass());

	public static final IFolder getFolder(IProject iProject, String folderName,
			boolean force) {
		IFolder folder = iProject.getFolder(folderName);
		if (!folder.isAccessible() && force) {
			try {
				folder.create(false, true, new NullProgressMonitor());
			} catch (CoreException e) {
			}
		}
		return folder;
	}

	public static final IFolder getFolder(IFolder ifolder, String folderName,
			boolean force) {
		IFolder folder = ifolder.getFolder(folderName);
		if (!folder.isAccessible() && force) {
			try {
				folder.create(false, true, new NullProgressMonitor());
			} catch (CoreException e) {
			}
		}
		return folder;
	}

	public static java.io.File cnvFile(IFolder folder) {
		java.io.File storeAsFile = null;
		try {
			IFileStore testLocationStore = EFS
					.getStore(folder.getLocationURI());
			storeAsFile = testLocationStore.toLocalFile(EFS.NONE, null);
		} catch (CoreException e) {
		}
		return storeAsFile;
	}

	public static final java.io.File cnvFile(IFile file) {
		java.io.File storeAsFile = null;
		try {
			IFileStore testLocationStore = EFS.getStore(file.getLocationURI());
			storeAsFile = testLocationStore.toLocalFile(EFS.NONE, null);
		} catch (CoreException e) {
		}
		return storeAsFile;
	}

	public static IFile createRandomFile(IFolder folder, String postfix) {
		return createRandomFile(folder, postfix, "scrap");
	}

	public static IFile createRandomFile(IFolder folder, String postfix,
			String prefix) {
		Random random = new Random(System.currentTimeMillis());
		String numbers = String.format("%s_%04d.%s", prefix,
				random.nextInt(10000), postfix);
		return createFile(folder, numbers);
	}

	public static final IFile createFile(IFolder folder, String name) {
		IFile file = folder.getFile(name);
		try {
			if (!file.exists()) {
				file.create(new ByteArrayInputStream(new byte[0]), false,
						new NullProgressMonitor());
			}
			// file.
		} catch (CoreException e) {
			e.printStackTrace();
		}
		return file;
	}

	public static final IFile createFile(IFolder folder, String name,
			boolean retry) {
		IFile file = folder.getFile(name);
		if (!file.exists()) {
			try {
				file.create(new ByteArrayInputStream(new byte[0]), false,
						new NullProgressMonitor());
			} catch (ResourceException e) {
				if (retry) {
					String newName = name.substring(0, name.lastIndexOf('.'));
					file = folder.getFile(newName + "_1."
							+ file.getFileExtension());
					try {
						file.create(new ByteArrayInputStream(new byte[0]),
								false, new NullProgressMonitor());
					} catch (CoreException e1) {
						fLogger.error(e);
					}
				}
			} catch (CoreException e) {
				fLogger.error(e);
			}
		}
		// file.
		return file;
	}
}
