package hiro.yoshioka.csveditor;

import hiro.yoshioka.csveditor.jsAction.JsAction;
import hiro.yoshioka.wolfcsveditor.Activator;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class CSVEditorContributor extends MultiPageEditorActionBarContributor
		implements ISelectionChangedListener {
	private IEditorPart activeEditorPart;
	private CSVRDHView csvViewPart;
	private Action adjustHeaderAction;
	private Action adjustDatumnAction;
	private Action adjustAreaAction;
	private Action configAction;
	private Action delColumnAction;
	private Action addColumnAction;
	private Action delRowAction;
	private Action addRowAction;
	private JsAction jsAction;

	/**
	 * Creates a multi-page contributor.
	 */
	public CSVEditorContributor() {
		super();
		createActions();
	}

	protected IAction getAction(ITextEditor editor, String actionID) {
		return (editor == null ? null : editor.getAction(actionID));
	}

	@Override
	public void setActiveEditor(IEditorPart part) {
		super.setActiveEditor(part);
		System.out.println("setActiveEditor=" + part);
	}

	public void setActivePage(IEditorPart part) {
		System.out.println("setActivePage=" + part);
		if (activeEditorPart == part)
			return;

		activeEditorPart = part;
		boolean enabled = false;
		System.out.println("enabled=" + enabled);
		try {
			if (part instanceof ITextEditor) {
			} else {
				if (csvViewPart == null) {
					csvViewPart = (CSVRDHView) part;
					csvViewPart.fViewer.addSelectionChangedListener(this);
					jsAction.setViewPart(csvViewPart);
				}
				enabled = true;
			}
			adjustHeaderAction.setEnabled(enabled);
			adjustDatumnAction.setEnabled(enabled);
			adjustAreaAction.setEnabled(enabled);
		} catch (Exception e) {
			e.printStackTrace();
		}

		IActionBars actionBars = getActionBars();
		if (actionBars != null) {
			if (part instanceof ITextEditor) {
				ITextEditor editor = (ITextEditor) part;
				actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(),
						getAction(editor, ITextEditorActionConstants.DELETE));
				actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(),
						getAction(editor, ITextEditorActionConstants.UNDO));
				actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(),
						getAction(editor, ITextEditorActionConstants.REDO));
				actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(),
						getAction(editor, ITextEditorActionConstants.CUT));
				actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(),
						getAction(editor, ITextEditorActionConstants.COPY));
				actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(),
						getAction(editor, ITextEditorActionConstants.PASTE));
				actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL
						.getId(), getAction(editor,
						ITextEditorActionConstants.SELECT_ALL));
				actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(),
						getAction(editor, ITextEditorActionConstants.FIND));
				actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK
						.getId(), getAction(editor, IDEActionFactory.BOOKMARK
						.getId()));
			} else {
			}
			actionBars.updateActionBars();
		}
	}

	private void createActions() {
		try {
			adjustHeaderAction = new Action() {
				public void run() {
					csvViewPart.adjustHeader();
				}
			};
			adjustHeaderAction.setText("Adjust Header Width");
			adjustHeaderAction.setToolTipText("Adjust Header Width");
			adjustHeaderAction.setImageDescriptor(Activator
					.getImageDescriptor("icons/action/50_colom.gif"));
			adjustDatumnAction = new Action() {
				public void run() {
					csvViewPart.adjustDatum();
				}
			};
			adjustDatumnAction.setText("Adjust Datumn Width");
			adjustDatumnAction.setToolTipText("Adjust Datumn Width");
			adjustDatumnAction.setImageDescriptor(Activator
					.getImageDescriptor("icons/action/51_long.gif"));
			adjustAreaAction = new Action() {
				public void run() {
					csvViewPart.adjustArea();
				}
			};
			adjustAreaAction.setText("Adjust Area Width");
			adjustAreaAction.setToolTipText("Adjust Area Width");
			adjustAreaAction.setImageDescriptor(Activator
					.getImageDescriptor("icons/action/15Index.gif"));
			configAction = new Action() {
				public void run() {
					csvViewPart.openConfigDialog();
				}
			};
			configAction.setText("CSV File Config");
			configAction.setToolTipText("CSV File Config");
			configAction.setImageDescriptor(Activator
					.getImageDescriptor("icons/misc/asterisk.gif"));
			delColumnAction = new Action() {
				public void run() {
					csvViewPart.deleteColumn();
				}
			};
			delColumnAction.setText("Delete Column");
			delColumnAction.setToolTipText("Delete Column");
			delColumnAction
					.setImageDescriptor(Activator
							.getImageDescriptor("icons/action/45_hide_table_column.png"));
			delColumnAction.setEnabled(false);
			//
			addColumnAction = new Action() {
				public void run() {
					csvViewPart.addColumn();
				}
			};

			addColumnAction.setText("Add Column");
			addColumnAction.setToolTipText("Add Column");
			addColumnAction
					.setImageDescriptor(Activator
							.getImageDescriptor("icons/action/45_show_table_column.png"));
			addColumnAction.setEnabled(false);
			//
			delRowAction = new Action() {
				public void run() {
					csvViewPart.deleteRow();
				}
			};
			delRowAction.setText("Delete Row");
			delRowAction.setToolTipText("Delete Row");
			delRowAction.setImageDescriptor(Activator
					.getImageDescriptor("icons/action/45_hide_table_row.png"));
			delRowAction.setEnabled(false);
			//
			addRowAction = new Action() {
				public void run() {
					csvViewPart.addRow();
				}
			};
			addRowAction.setText("Add Row");
			addRowAction.setToolTipText("Add Row");
			addRowAction.setImageDescriptor(Activator
					.getImageDescriptor("icons/action/45_show_table_row.png"));
			jsAction = new JsAction(csvViewPart);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public void contributeToMenu(IMenuManager manager) {
		IMenuManager menu = new MenuManager("CSV Editor &Menu");
		manager.prependToGroup(IWorkbenchActionConstants.MB_ADDITIONS, menu);
		menu.add(adjustHeaderAction);
		menu.add(adjustDatumnAction);
		menu.add(adjustAreaAction);
		menu.add(new Separator());
		menu.add(configAction);
		menu.add(new Separator());
		menu.add(delColumnAction);
		menu.add(addColumnAction);
		menu.add(delRowAction);
		menu.add(addRowAction);
		menu.add(new Separator());
		menu.add(jsAction);
	}

	public void contributeToToolBar(IToolBarManager manager) {
		manager.add(new Separator());
		manager.add(adjustHeaderAction);
		manager.add(adjustDatumnAction);
		manager.add(adjustAreaAction);
		manager.add(new Separator());
		manager.add(configAction);
		manager.add(new Separator());
		manager.add(delColumnAction);
		manager.add(addColumnAction);
		manager.add(delRowAction);
		manager.add(addRowAction);
		manager.add(new Separator());
		manager.add(jsAction);
	}

	@Override
	public void selectionChanged(SelectionChangedEvent event) {
		boolean columnEnabled = csvViewPart.fViewer.getLastSelectedColumn() >= 0;
		addColumnAction.setEnabled(columnEnabled);
		delColumnAction.setEnabled(columnEnabled);
		boolean rowEnabled = csvViewPart.fViewer.getLastSelectedRow() >= 0;
		delRowAction.setEnabled(rowEnabled);
	}
}
