/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexBuilder {
    public static final String PRIMARY_KEY_NAME = "PrimaryKey";
    private String _name;
    private byte _type;
    private byte _flags = (byte)-128;
    private final List<Column> _columns = new ArrayList<Column>();

    public IndexBuilder(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public byte getType() {
        return this._type;
    }

    public byte getFlags() {
        return this._flags;
    }

    public boolean isPrimaryKey() {
        return this.getType() == 1;
    }

    public boolean isUnique() {
        return (this.getFlags() & 1) != 0;
    }

    public boolean isIgnoreNulls() {
        return (this.getFlags() & 2) != 0;
    }

    public List<Column> getColumns() {
        return this._columns;
    }

    public IndexBuilder setName(String name) {
        this._name = name;
        return this;
    }

    public IndexBuilder addColumns(String ... names) {
        return this.addColumns(true, names);
    }

    public IndexBuilder addColumns(boolean ascending, String ... names) {
        if (names != null) {
            for (String name : names) {
                this._columns.add(new Column(name, ascending));
            }
        }
        return this;
    }

    public IndexBuilder setPrimaryKey() {
        this._type = 1;
        return this.setUnique();
    }

    public IndexBuilder setUnique() {
        this._flags = (byte)(this._flags | 1);
        return this;
    }

    public IndexBuilder setIgnoreNulls() {
        this._flags = (byte)(this._flags | 2);
        return this;
    }

    public void validate(Set<String> tableColNames) {
        if (this.getColumns().isEmpty()) {
            throw new IllegalArgumentException("index " + this.getName() + " has no columns");
        }
        if (this.getColumns().size() > 10) {
            throw new IllegalArgumentException("index " + this.getName() + " has too many columns, max " + 10);
        }
        HashSet<String> idxColNames = new HashSet<String>();
        for (Column col : this.getColumns()) {
            String idxColName = col.getName().toUpperCase();
            if (!idxColNames.add(idxColName)) {
                throw new IllegalArgumentException("duplicate column name " + col.getName() + " in index " + this.getName());
            }
            if (tableColNames.contains(idxColName)) continue;
            throw new IllegalArgumentException("column named " + col.getName() + " not found in table");
        }
    }

    public static class Column {
        private String _name;
        private byte _flags;

        private Column(String name, boolean ascending) {
            this._name = name;
            this._flags = ascending ? (byte)1 : 0;
        }

        public String getName() {
            return this._name;
        }

        public Column setName(String name) {
            this._name = name;
            return this;
        }

        public boolean isAscending() {
            return (this.getFlags() & 1) != 0;
        }

        public byte getFlags() {
            return this._flags;
        }
    }
}

