/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.ByteUtil;
import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.IndexData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralLegacyIndexCodes {
    static final int MAX_TEXT_INDEX_CHAR_LENGTH = 255;
    static final byte END_TEXT = 1;
    static final byte END_EXTRA_TEXT = 0;
    static final int UNPRINTABLE_COUNT_START = 7;
    static final int UNPRINTABLE_COUNT_MULTIPLIER = 4;
    static final int UNPRINTABLE_OFFSET_FLAGS = 32768;
    static final byte UNPRINTABLE_MIDFIX = 6;
    static final byte INTERNATIONAL_EXTRA_PLACEHOLDER = 2;
    static final byte CRAZY_CODE_START = -128;
    static final byte CRAZY_CODE_1 = 2;
    static final byte CRAZY_CODE_2 = 3;
    static final byte[] CRAZY_CODES_SUFFIX = new byte[]{-1, 2, -128, -1, -128};
    static final byte CRAZY_CODES_UNPRINT_SUFFIX = -1;
    private static final String CODES_FILE = Database.RESOURCE_PATH + "index_codes_genleg.txt";
    private static final String EXT_CODES_FILE = Database.RESOURCE_PATH + "index_codes_ext_genleg.txt";
    static final CharHandler IGNORED_CHAR_HANDLER = new CharHandler(){

        public Type getType() {
            return Type.IGNORED;
        }
    };
    static final CharHandler SURROGATE_CHAR_HANDLER = new CharHandler(){

        public Type getType() {
            return Type.IGNORED;
        }

        public byte[] getInlineBytes() {
            throw new IllegalStateException("Surrogate pair chars are not handled");
        }
    };
    static final char FIRST_CHAR = '\u0000';
    static final char LAST_CHAR = '\u00ff';
    static final char FIRST_EXT_CHAR = '\u0100';
    static final char LAST_EXT_CHAR = '\uffff';
    static final GeneralLegacyIndexCodes GEN_LEG_INSTANCE = new GeneralLegacyIndexCodes();

    GeneralLegacyIndexCodes() {
    }

    CharHandler getCharHandler(char c) {
        if (c <= '\u00ff') {
            return Codes._values[c];
        }
        int extOffset = GeneralLegacyIndexCodes.asUnsignedChar(c) - GeneralLegacyIndexCodes.asUnsignedChar('\u0100');
        return ExtCodes._values[extOffset];
    }

    static CharHandler[] loadCodes(String codesFilePath, char firstChar, char lastChar) {
        int numCodes = GeneralLegacyIndexCodes.asUnsignedChar(lastChar) - GeneralLegacyIndexCodes.asUnsignedChar(firstChar) + 1;
        CharHandler[] values = new CharHandler[numCodes];
        HashMap<String, Type> prefixMap = new HashMap<String, Type>();
        for (Type type : Type.values()) {
            prefixMap.put(type.getPrefixCode(), type);
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(Database.getResourceAsStream(codesFilePath), "US-ASCII"));
            int start = GeneralLegacyIndexCodes.asUnsignedChar(firstChar);
            int end = GeneralLegacyIndexCodes.asUnsignedChar(lastChar);
            for (int i = start; i <= end; ++i) {
                char c = (char)i;
                CharHandler ch = null;
                if (Character.isHighSurrogate(c) || Character.isLowSurrogate(c)) {
                    ch = SURROGATE_CHAR_HANDLER;
                } else {
                    String codeLine = reader.readLine();
                    ch = GeneralLegacyIndexCodes.parseCodes(prefixMap, codeLine);
                }
                values[i - start] = ch;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("failed loading index codes file " + codesFilePath, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
        return values;
    }

    private static CharHandler parseCodes(Map<String, Type> prefixMap, String codeLine) {
        String prefix = codeLine.substring(0, 1);
        String suffix = codeLine.length() > 1 ? codeLine.substring(1) : "";
        return prefixMap.get(prefix).parseCodes(suffix.split(",", -1));
    }

    private static CharHandler parseSimpleCodes(String[] codeStrings) {
        if (codeStrings.length != 1) {
            throw new IllegalStateException("Unexpected code strings " + Arrays.asList(codeStrings));
        }
        return new SimpleCharHandler(GeneralLegacyIndexCodes.codesToBytes(codeStrings[0], true));
    }

    private static CharHandler parseInternationalCodes(String[] codeStrings) {
        if (codeStrings.length != 2) {
            throw new IllegalStateException("Unexpected code strings " + Arrays.asList(codeStrings));
        }
        return new InternationalCharHandler(GeneralLegacyIndexCodes.codesToBytes(codeStrings[0], true), GeneralLegacyIndexCodes.codesToBytes(codeStrings[1], true));
    }

    private static CharHandler parseUnprintableCodes(String[] codeStrings) {
        if (codeStrings.length != 1) {
            throw new IllegalStateException("Unexpected code strings " + Arrays.asList(codeStrings));
        }
        return new UnprintableCharHandler(GeneralLegacyIndexCodes.codesToBytes(codeStrings[0], true));
    }

    private static CharHandler parseUnprintableExtCodes(String[] codeStrings) {
        if (codeStrings.length != 1) {
            throw new IllegalStateException("Unexpected code strings " + Arrays.asList(codeStrings));
        }
        byte[] bytes = GeneralLegacyIndexCodes.codesToBytes(codeStrings[0], true);
        if (bytes.length != 1) {
            throw new IllegalStateException("Unexpected code strings " + Arrays.asList(codeStrings));
        }
        return new UnprintableExtCharHandler(bytes[0]);
    }

    private static CharHandler parseInternationalExtCodes(String[] codeStrings) {
        if (codeStrings.length != 3) {
            throw new IllegalStateException("Unexpected code strings " + Arrays.asList(codeStrings));
        }
        byte crazyFlag = "1".equals(codeStrings[2]) ? (byte)2 : 3;
        return new InternationalExtCharHandler(GeneralLegacyIndexCodes.codesToBytes(codeStrings[0], true), GeneralLegacyIndexCodes.codesToBytes(codeStrings[1], false), crazyFlag);
    }

    private static byte[] codesToBytes(String codes, boolean required) {
        if (codes.length() == 0) {
            if (required) {
                throw new IllegalStateException("empty code bytes");
            }
            return null;
        }
        if (codes.length() % 2 != 0) {
            codes = "0" + codes;
        }
        byte[] bytes = new byte[codes.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int charIdx = i * 2;
            bytes[i] = (byte)Integer.parseInt(codes.substring(charIdx, charIdx + 2), 16);
        }
        return bytes;
    }

    static int asUnsignedChar(char c) {
        return c & 0xFFFF;
    }

    void writeNonNullIndexTextValue(Object value, ByteUtil.ByteStream bout, boolean isAscending) throws IOException {
        boolean hasCrazyCodes;
        String str = ((Object)Column.toCharSequence(value)).toString();
        if (str.length() > 255) {
            str = str.substring(0, 255);
        }
        int prevLength = bout.getLength();
        ByteUtil.ByteStream extraCodes = null;
        ByteUtil.ByteStream unprintableCodes = null;
        ByteUtil.ByteStream crazyCodes = null;
        int charOffset = 0;
        for (int i = 0; i < str.length(); ++i) {
            byte crazyFlag;
            char c = str.charAt(i);
            CharHandler ch = this.getCharHandler(c);
            int curCharOffset = charOffset++;
            byte[] bytes = ch.getInlineBytes();
            if (bytes != null) {
                bout.write(bytes);
            }
            if (ch.getType() == Type.SIMPLE) continue;
            bytes = ch.getExtraBytes();
            byte extraCodeModifier = ch.getExtraByteModifier();
            if (bytes != null || extraCodeModifier != 0) {
                if (extraCodes == null) {
                    extraCodes = new ExtraCodesStream(str.length());
                }
                GeneralLegacyIndexCodes.writeExtraCodes(curCharOffset, bytes, extraCodeModifier, (ExtraCodesStream)extraCodes);
            }
            if ((bytes = ch.getUnprintableBytes()) != null) {
                if (unprintableCodes == null) {
                    unprintableCodes = new ByteUtil.ByteStream();
                }
                GeneralLegacyIndexCodes.writeUnprintableCodes(curCharOffset, bytes, unprintableCodes, (ExtraCodesStream)extraCodes);
            }
            if ((crazyFlag = ch.getCrazyFlag()) == 0) continue;
            if (crazyCodes == null) {
                crazyCodes = new ByteUtil.ByteStream();
            }
            crazyCodes.write(crazyFlag);
        }
        bout.write(1);
        boolean hasExtraCodes = GeneralLegacyIndexCodes.trimExtraCodes(extraCodes, (byte)0, (byte)2);
        boolean hasUnprintableCodes = unprintableCodes != null;
        boolean bl = hasCrazyCodes = crazyCodes != null;
        if (hasExtraCodes || hasUnprintableCodes || hasCrazyCodes) {
            if (hasExtraCodes) {
                extraCodes.writeTo(bout);
            }
            if (hasCrazyCodes || hasUnprintableCodes) {
                bout.write(1);
                bout.write(1);
                if (hasCrazyCodes) {
                    GeneralLegacyIndexCodes.writeCrazyCodes(crazyCodes, bout);
                    if (hasUnprintableCodes) {
                        bout.write(-1);
                    }
                }
                if (hasUnprintableCodes) {
                    bout.write(1);
                    unprintableCodes.writeTo(bout);
                }
            }
        }
        if (!isAscending) {
            bout.write(0);
            IndexData.flipBytes(bout.getBytes(), prevLength, bout.getLength() - prevLength);
        }
        bout.write(0);
    }

    private static void writeExtraCodes(int charOffset, byte[] bytes, byte extraCodeModifier, ExtraCodesStream extraCodes) throws IOException {
        int numChars = extraCodes.getNumChars();
        if (numChars < charOffset) {
            int fillChars = charOffset - numChars;
            extraCodes.writeFill(fillChars, (byte)2);
            extraCodes.incrementNumChars(fillChars);
        }
        if (bytes != null) {
            extraCodes.write(bytes);
            extraCodes.incrementNumChars(1);
        } else {
            int lastIdx = extraCodes.getLength() - 1;
            if (lastIdx >= 0) {
                byte lastByte = extraCodes.get(lastIdx);
                lastByte = (byte)(lastByte + extraCodeModifier);
                extraCodes.set(lastIdx, lastByte);
            } else {
                extraCodes.write(extraCodeModifier);
                extraCodes.setUnprintablePrefixLen(1);
            }
        }
    }

    private static boolean trimExtraCodes(ByteUtil.ByteStream extraCodes, byte minTrimCode, byte maxTrimCode) throws IOException {
        if (extraCodes == null) {
            return false;
        }
        extraCodes.trimTrailing(minTrimCode, maxTrimCode);
        return extraCodes.getLength() > 0;
    }

    private static void writeUnprintableCodes(int charOffset, byte[] bytes, ByteUtil.ByteStream unprintableCodes, ExtraCodesStream extraCodes) throws IOException {
        int unprintCharOffset = charOffset;
        if (extraCodes != null) {
            unprintCharOffset = extraCodes.getLength() + (charOffset - extraCodes.getNumChars()) - extraCodes.getUnprintablePrefixLen();
        }
        int offset = 7 + 4 * unprintCharOffset | 0x8000;
        unprintableCodes.write(offset >> 8 & 0xFF);
        unprintableCodes.write(offset & 0xFF);
        unprintableCodes.write(6);
        unprintableCodes.write(bytes);
    }

    private static void writeCrazyCodes(ByteUtil.ByteStream crazyCodes, ByteUtil.ByteStream bout) throws IOException {
        GeneralLegacyIndexCodes.trimExtraCodes(crazyCodes, (byte)3, (byte)3);
        if (crazyCodes.getLength() > 0) {
            int curByte = -128;
            int idx = 0;
            for (int i = 0; i < crazyCodes.getLength(); ++i) {
                byte nextByte = crazyCodes.get(i);
                nextByte = (byte)(nextByte << (2 - idx) * 2);
                curByte = (byte)(curByte | nextByte);
                if (++idx != 3) continue;
                bout.write(curByte);
                curByte = -128;
                idx = 0;
            }
            if (idx > 0) {
                bout.write(curByte);
            }
        }
        bout.write(CRAZY_CODES_SUFFIX);
    }

    static /* synthetic */ String access$600() {
        return CODES_FILE;
    }

    static /* synthetic */ String access$700() {
        return EXT_CODES_FILE;
    }

    private static final class ExtraCodesStream
    extends ByteUtil.ByteStream {
        private int _numChars;
        private int _unprintablePrefixLen;

        private ExtraCodesStream(int length) {
            super(length);
        }

        public int getNumChars() {
            return this._numChars;
        }

        public void incrementNumChars(int inc) {
            this._numChars += inc;
        }

        public int getUnprintablePrefixLen() {
            return this._unprintablePrefixLen;
        }

        public void setUnprintablePrefixLen(int len) {
            this._unprintablePrefixLen = len;
        }
    }

    private static final class ExtCodes {
        private static final CharHandler[] _values = GeneralLegacyIndexCodes.loadCodes(GeneralLegacyIndexCodes.access$700(), '\u0100', '\uffff');

        private ExtCodes() {
        }
    }

    private static final class Codes {
        private static final CharHandler[] _values = GeneralLegacyIndexCodes.loadCodes(GeneralLegacyIndexCodes.access$600(), '\u0000', '\u00ff');

        private Codes() {
        }
    }

    private static final class InternationalExtCharHandler
    extends CharHandler {
        private byte[] _bytes;
        private byte[] _extraBytes;
        private byte _crazyFlag;

        private InternationalExtCharHandler(byte[] bytes, byte[] extraBytes, byte crazyFlag) {
            this._bytes = bytes;
            this._extraBytes = extraBytes;
            this._crazyFlag = crazyFlag;
        }

        public Type getType() {
            return Type.INTERNATIONAL_EXT;
        }

        public byte[] getInlineBytes() {
            return this._bytes;
        }

        public byte[] getExtraBytes() {
            return this._extraBytes;
        }

        public byte getCrazyFlag() {
            return this._crazyFlag;
        }
    }

    private static final class UnprintableExtCharHandler
    extends CharHandler {
        private byte _extraByteMod;

        private UnprintableExtCharHandler(Byte extraByteMod) {
            this._extraByteMod = extraByteMod;
        }

        public Type getType() {
            return Type.UNPRINTABLE_EXT;
        }

        public byte getExtraByteModifier() {
            return this._extraByteMod;
        }
    }

    private static final class UnprintableCharHandler
    extends CharHandler {
        private byte[] _unprintBytes;

        private UnprintableCharHandler(byte[] unprintBytes) {
            this._unprintBytes = unprintBytes;
        }

        public Type getType() {
            return Type.UNPRINTABLE;
        }

        public byte[] getUnprintableBytes() {
            return this._unprintBytes;
        }
    }

    private static final class InternationalCharHandler
    extends CharHandler {
        private byte[] _bytes;
        private byte[] _extraBytes;

        private InternationalCharHandler(byte[] bytes, byte[] extraBytes) {
            this._bytes = bytes;
            this._extraBytes = extraBytes;
        }

        public Type getType() {
            return Type.INTERNATIONAL;
        }

        public byte[] getInlineBytes() {
            return this._bytes;
        }

        public byte[] getExtraBytes() {
            return this._extraBytes;
        }
    }

    private static final class SimpleCharHandler
    extends CharHandler {
        private byte[] _bytes;

        private SimpleCharHandler(byte[] bytes) {
            this._bytes = bytes;
        }

        public Type getType() {
            return Type.SIMPLE;
        }

        public byte[] getInlineBytes() {
            return this._bytes;
        }
    }

    static abstract class CharHandler {
        CharHandler() {
        }

        public abstract Type getType();

        public byte[] getInlineBytes() {
            return null;
        }

        public byte[] getExtraBytes() {
            return null;
        }

        public byte[] getUnprintableBytes() {
            return null;
        }

        public byte getExtraByteModifier() {
            return 0;
        }

        public byte getCrazyFlag() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        SIMPLE("S"){

            public CharHandler parseCodes(String[] codeStrings) {
                return GeneralLegacyIndexCodes.parseSimpleCodes(codeStrings);
            }
        }
        ,
        INTERNATIONAL("I"){

            public CharHandler parseCodes(String[] codeStrings) {
                return GeneralLegacyIndexCodes.parseInternationalCodes(codeStrings);
            }
        }
        ,
        UNPRINTABLE("U"){

            public CharHandler parseCodes(String[] codeStrings) {
                return GeneralLegacyIndexCodes.parseUnprintableCodes(codeStrings);
            }
        }
        ,
        UNPRINTABLE_EXT("P"){

            public CharHandler parseCodes(String[] codeStrings) {
                return GeneralLegacyIndexCodes.parseUnprintableExtCodes(codeStrings);
            }
        }
        ,
        INTERNATIONAL_EXT("Z"){

            public CharHandler parseCodes(String[] codeStrings) {
                return GeneralLegacyIndexCodes.parseInternationalExtCodes(codeStrings);
            }
        }
        ,
        IGNORED("X"){

            public CharHandler parseCodes(String[] codeStrings) {
                return IGNORED_CHAR_HANDLER;
            }
        };

        private final String _prefixCode;

        private Type(String prefixCode) {
            this._prefixCode = prefixCode;
        }

        public String getPrefixCode() {
            return this._prefixCode;
        }

        public abstract CharHandler parseCodes(String[] var1);
    }
}

