/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.filters;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.regex.Pattern;
import jp.sf.orangesignal.csv.handlers.BeanListHandlerSupport;

abstract class BeanExpressionUtils {
    protected BeanExpressionUtils() {
    }

    public static boolean isNull(Object bean, String name) throws IOException {
        return BeanExpressionUtils.getFieldValue(bean, name) == null;
    }

    public static boolean isNotNull(Object bean, String name) throws IOException {
        return !BeanExpressionUtils.isNull(bean, name);
    }

    public static boolean isEmpty(Object bean, String name) throws IOException {
        Field field = BeanListHandlerSupport.getField(bean.getClass(), name);
        Object value = BeanListHandlerSupport.getFieldValue(bean, field);
        if (value == null) {
            return true;
        }
        if (field.getType().isArray()) {
            return ((Object[])value).length == 0;
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        return false;
    }

    public static boolean isNotEmpty(Object bean, String name) throws IOException {
        return !BeanExpressionUtils.isEmpty(bean, name);
    }

    public static boolean eq(Object bean, String name, Object criteria, boolean ignoreCase) throws IOException {
        Object value = BeanExpressionUtils.getFieldValue(bean, name);
        if (criteria == null) {
            throw new IllegalArgumentException("Criteria must not be null");
        }
        if (ignoreCase) {
            return value != null && ((String)criteria).equalsIgnoreCase((String)value);
        }
        return value != null && criteria.equals(value);
    }

    public static boolean ne(Object bean, String name, Object criteria, boolean ignoreCase) throws IOException {
        return !BeanExpressionUtils.eq(bean, name, criteria, ignoreCase);
    }

    public static boolean in(Object bean, String name, Object[] criterias, boolean ignoreCase) throws IOException {
        if (criterias == null) {
            throw new IllegalArgumentException("Criterias must not be null");
        }
        for (Object criteria : criterias) {
            if (!BeanExpressionUtils.eq(bean, name, criteria, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public static boolean notIn(Object bean, String name, Object[] criterias, boolean ignoreCase) throws IOException {
        return !BeanExpressionUtils.in(bean, name, criterias, ignoreCase);
    }

    public static boolean regex(Object bean, String name, Pattern pattern) throws IOException {
        Object value = BeanExpressionUtils.getFieldValue(bean, name);
        return value != null && pattern.matcher((CharSequence)value).matches();
    }

    public static boolean gt(Object bean, String name, Object criteria, Comparator comparator) throws IOException {
        Object value = BeanExpressionUtils.getFieldValue(bean, name);
        if (comparator != null) {
            return value != null && criteria != null && comparator.compare(value, criteria) > 0;
        }
        return value != null && criteria != null && ((Comparable)value).compareTo(criteria) > 0;
    }

    public static boolean lt(Object bean, String name, Object criteria, Comparator comparator) throws IOException {
        Object value = BeanExpressionUtils.getFieldValue(bean, name);
        if (comparator != null) {
            return value != null && criteria != null && comparator.compare(value, criteria) < 0;
        }
        return value != null && criteria != null && ((Comparable)value).compareTo(criteria) < 0;
    }

    public static boolean ge(Object bean, String name, Object criteria, Comparator comparator) throws IOException {
        Object value = BeanExpressionUtils.getFieldValue(bean, name);
        if (comparator != null) {
            return value != null && criteria != null && comparator.compare(value, criteria) >= 0;
        }
        return value != null && criteria != null && ((Comparable)value).compareTo(criteria) >= 0;
    }

    public static boolean le(Object bean, String name, Object criteria, Comparator comparator) throws IOException {
        Object value = BeanExpressionUtils.getFieldValue(bean, name);
        if (comparator != null) {
            return value != null && criteria != null && comparator.compare(value, criteria) <= 0;
        }
        return value != null && criteria != null && ((Comparable)value).compareTo(criteria) <= 0;
    }

    public static boolean between(Object bean, String name, Object low, Object high, Comparator comparator) throws IOException {
        return BeanExpressionUtils.ge(bean, name, low, comparator) && BeanExpressionUtils.le(bean, name, high, comparator);
    }

    private static Object getFieldValue(Object bean, String name) throws IOException {
        return BeanListHandlerSupport.getFieldValue(bean, BeanListHandlerSupport.getField(bean.getClass(), name));
    }
}

