package sql.mirroring;

import hiro.yoshioka.sql.engine.MirroringRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.RequestAdaptor;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.IDBColumn;

public class MirroringFromDominoToHsqlTest extends AbsMirroringTest {

	@Override
	void setUpMirroringConnection() {
		this.mirroring_to_con_properties = bean.getLocalHsqlServerConnection();
		for (ConnectionProperties p : bean.getConnectionSet()) {
			if (p.getDatabaseType().isDomino()) {
				mirroring_from_con_properties = p;
				break;
			}
		}
	}

	public void testMirroringHoge() {
		MirroringRequest request = new MirroringRequest(
				this.mirroring_from_con_properties, mirroring_to_con_properties);
		request.dropSchema = true;
		request.dropTable = true;
		request.cascade = true;
		request.makeBlob = true;
		request.maxRowNum = 1002;
		request.putSchemaMapping("hoge", "hoge");
		request.putMirroringTable("hoge", "ReportDoc", true);
		request.putSchemaMapping("エイリアス有", "エイリアス有");
		request.putMirroringTable("エイリアス有", "NewsDoc", true);
		// If you use a reserved word column name, column name substitution is
		// required.
		// For example, in HSQLDB "SUM" column name not be used in.
		DBRoot root = mirroring_from_con_properties.getDBRootResource();
		request.putColumnNameSubstitution("sum", "sum_");

		request.addListener(new RequestAdaptor() {
			@Override
			public void beginTask(String taskName, int row) {
				System.out.println(String.format("  BEGINE %s [%d]", taskName,
						row));
			}

			@Override
			public void subTask(String subTaskName) {
				System.out.println(String.format("  SUB_TASK %s", subTaskName));
			}

			@Override
			public void called_done(Request request,
					SQLOperationType operation,
					ConnectionProperties properteis, Object o) {
				System.out.println(String.format("  DONE %s [%s]", operation,
						properteis.getDisplayString()));
			}
		});

		assertTrue("Mirroring Success",
				SQLServerThread.runNowThisRequest(request));
	}

}
