package hiro.yoshioka.sql.resource.view;

import hiro.yoshioka.sql.ResourceSorter;
import hiro.yoshioka.util.ImageUtil;
import hiro.yoshioka.util.ui.MySubjectControlContentAssistant;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class DBResourceCompositeMaker {
	DBResourceTreeViewer viewer;
	Text fSearchText;
	Button fSortButton;
	MySubjectControlContentAssistant fMySubjectControlContentAssistant;
	boolean runningOnEclipse;
	Composite c;

	private DBResourceCompositeMaker(boolean runningOnEclipse) {
		this.runningOnEclipse = runningOnEclipse;
	}

	public static DBResourceCompositeMaker getInstance(boolean runningOnEclipse) {
		return new DBResourceCompositeMaker(runningOnEclipse);
	}

	public Composite getMainComposite() {
		return c;
	}

	private void createSearchText(Composite parent) {
		Composite c = new Composite(parent, SWT.BORDER);
		c.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		GridLayout gl = new GridLayout(4, false);
		gl.horizontalSpacing = 2;
		gl.verticalSpacing = 0;
		gl.marginWidth = 0;
		gl.marginHeight = 0;
		c.setLayout(gl);
		Button configBtn = new Button(c, SWT.PUSH);
		configBtn
				.setText(Messages.getString("DBResourceCompositeMaker.Config")); //$NON-NLS-1$
		configBtn
				.setImage(ImageUtil.getImage(ImageUtil.ACTION_00_TREE_REFRESH));
		configBtn.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				viewer.openConfigDialog();
			}
		});
		fSortButton = new Button(c, SWT.TOGGLE);
		// fSortButton.setText("Sort");
		fSortButton.setImage(ImageUtil.getImage(ImageUtil.ACTION_53_SORT));
		fSortButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				int sortMode = fSortButton.getSelection() ? ResourceSorter.SORT_CATEGORY
						: ResourceSorter.SORT_NOTHING;
				viewer.setSortMode(sortMode);
			}
		});
		new Label(c, SWT.NONE).setText(Messages
				.getString("DBResourceCompositeMaker.Filter")); //$NON-NLS-1$
		fSearchText = new Text(c, SWT.SINGLE | SWT.BORDER);
		fSearchText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		fSearchText.setToolTipText("AutoCompletion <CTRL+SPACE>"); //$NON-NLS-1$
		if (runningOnEclipse) {
			fMySubjectControlContentAssistant = new MySubjectControlContentAssistant(
					fSearchText);
		} else {
			fSearchText.addKeyListener(new KeyAdapter() {

				@Override
				public void keyReleased(org.eclipse.swt.events.KeyEvent e) {
					if (e.stateMask == SWT.CTRL && e.character == ' ') {
						e.doit = false;
					} else if (e.character == '\r' || e.character == '\n') {
						viewer.pressEnter(fSearchText.getText());
						e.doit = false;
					}
				}
			});
		}
	}

	public Composite createControl(Composite parent) {
		c = new Composite(parent, SWT.NONE);
		GridLayout g = new GridLayout();
		g.marginBottom = 0;
		g.marginTop = 0;
		g.marginLeft = 0;
		g.marginRight = 0;
		g.marginWidth = 0;
		g.marginHeight = 0;
		g.verticalSpacing = 0;
		g.horizontalSpacing = 0;
		c.setLayout(g);

		createSearchText(c);

		viewer = new DBResourceTreeViewer(c);
		if (runningOnEclipse) {
			fMySubjectControlContentAssistant.addPressEnterListener(viewer);
			viewer.setInput(null);
		}
		viewer.setInput(null);
		viewer.getTree().setLayoutData(new GridData(GridData.FILL_BOTH));
		return c;

	}

	public DBResourceTreeViewer getTreeViewer() {
		return viewer;
	}

	public Text getSearchText() {
		return fSearchText;
	}

}
